<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Taskrouter\V1\Workspace;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;

class TaskQueueBulkRealTimeStatisticsList extends ListResource {
    /**
     * Construct the TaskQueueBulkRealTimeStatisticsList
     *
     * @param Version $version Version that contains the resource
     * @param string $workspaceSid The SID of the Workspace that contains the
     *                             TaskQueue
     */
    public function __construct(Version $version, string $workspaceSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['workspaceSid' => $workspaceSid, ];

        $this->uri = '/Workspaces/' . \rawurlencode($workspaceSid) . '/TaskQueues/RealTimeStatistics';
    }

    /**
     * Create the TaskQueueBulkRealTimeStatisticsInstance
     *
     * @return TaskQueueBulkRealTimeStatisticsInstance Created
     *                                                 TaskQueueBulkRealTimeStatisticsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(): TaskQueueBulkRealTimeStatisticsInstance {
        $payload = $this->version->create('POST', $this->uri);

        return new TaskQueueBulkRealTimeStatisticsInstance(
            $this->version,
            $payload,
            $this->solution['workspaceSid']
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Taskrouter.V1.TaskQueueBulkRealTimeStatisticsList]';
    }
}