
<?php $__env->startSection('main-content'); ?>
<?php $__env->startSection('page-css'); ?>

<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/nprogress.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/datepicker.min.css')); ?>">


<?php $__env->stopSection(); ?>

<div class="breadcrumb">
    <h1><?php echo e(__('translate.Customer_details')); ?></h1>
</div>

<div class="separator-breadcrumb border-top"></div>



<div id="section_Client_details">
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="ol-lg-3 col-md-6 col-sm-6 col-12">
                    <table class="display table table-md">
                        <tbody>
                            <tr>
                                <th><?php echo e(__('translate.FullName')); ?></th>
                                <td><?php echo e($client_data['full_name']); ?></td>
                            </tr>
                            <tr>
                                <th><?php echo e(__('translate.Code')); ?></th>
                                <td><?php echo e($client_data['code']); ?></td>
                            </tr>
                            <tr>
                                <th><?php echo e(__('translate.Phone')); ?></th>
                                <td><?php echo e($client_data['phone']); ?></td>
                            </tr>
                            <tr>
                                <th><?php echo e(__('translate.Address')); ?></th>
                                <td><?php echo e($client_data['address']); ?></td>
                            </tr>

                            <tr>
                                <th>Medical History</th>
                                <td><?php echo e($client_data['medicalhis']); ?></td>
                            </tr>

                            <tr>
                                <th>Blood Group</th>
                                <td><?php echo e($client_data['bgroup']); ?></td>
                            </tr>

                            <tr>
                                <th>Allergie</th>
                                <td><?php echo e($client_data['allergie']); ?></td>
                            </tr>

                            <tr>
                                <th>Age</th>
                                <td><?php echo e($client_data['age']); ?></td>
                            </tr>


                            <tr>
                                <th>Weight</th>
                                <td><?php echo e($client_data['weight']); ?></td>
                            </tr>



                            <tr>
                                <th><?php echo e(__('translate.Status')); ?></th>
                                <td>
                                    <?php if($client_data['status'] == 1): ?>
                                    <span class="badge badge-success"><?php echo e(__('translate.Active Client')); ?></span>
                                    <?php else: ?>
                                    <span class="badge badge-danger"><?php echo e(__('translate.Inactive Client')); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row">

                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="card card-icon-big mb-4">
                        <div class="card-body text-center">
                            <i class="i-Full-Cart"></i>
                            <div class="content">
                                <p class="text-muted mt-2 mb-2"><?php echo e(__('translate.Total Sales')); ?></p>
                                <p class="text-primary text-24 line-height-1 m-0" id="sales_data">
                                    <?php echo e($client_data['total_sales']); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="card card-icon-big mb-4">
                        <div class="card-body text-center">
                            <i class="i-Money-2"></i>
                            <div class="content">
                                <p class="text-muted mt-2 mb-2"><?php echo e(__('translate.Total Amount')); ?></p>
                                <p class="text-primary text-24 line-height-1 m-0" id="purchases_data">
                                    <?php echo e($client_data['total_amount']); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="card card-icon-big mb-4">
                        <div class="card-body text-center">
                            <i class="i-Money-Bag"></i>
                            <div class="content">
                                <p class="text-muted mt-2 mb-2"><?php echo e(__('translate.Total paid')); ?></p>
                                <p class="text-primary text-24 line-height-1 m-0" id="return_sales_data">
                                    <?php echo e($client_data['total_paid']); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="card card-icon-big mb-4">
                        <div class="card-body text-center">
                            <i class="i-Financial"></i>
                            <div class="content">
                                <p class="text-muted mt-2 mb-2"><?php echo e(__('translate.Total debt')); ?></p>
                                <p class="text-primary text-24 line-height-1 m-0" id="return_purchases_data">
                                    <?php echo e($client_data['total_debt']); ?></p>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>


</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-js'); ?>

<script src="<?php echo e(asset('assets/js/nprogress.js')); ?>"></script>



<script>
    var app = new Vue({
        el: '#section_Client_details',
        data: {
            SubmitProcessing:false,
        },
       
        methods: {
        
          
           
        },
        //-----------------------------Autoload function-------------------
        created() {
        }
    })
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/itlabsys/public_html/niwethma.itlabsystems.lk/resources/views/clients/details_client.blade.php ENDPATH**/ ?>