
<?php $__env->startSection('main-content'); ?>
<?php $__env->startSection('page-css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/datatables.min.css')); ?>">

<?php $__env->stopSection(); ?>

<div class="breadcrumb">
  <h1><?php echo e(__('translate.Permissions')); ?></h1>
</div>

<div class="separator-breadcrumb border-top"></div>

<div class="row" id="section_Permissions_list">
  <div class="col-md-12">
    <div class="card">
      <div class="card-body">
        <div class="text-end mb-3">

          <a class="btn btn-outline-primary btn-md m-1" href="<?php echo e(route('permissions.create')); ?>"><i
              class="i-Add me-2 font-weight-bold"></i> <?php echo e(__('translate.Create')); ?></a>
        </div>
        <div class="table-responsive">
          <table id="permissions_table" class="display table">
            <thead>
              <tr>
                <th><?php echo e(__('translate.Role_Name')); ?></th>
                <th><?php echo e(__('translate.Description')); ?></th>
                <th><?php echo e(__('translate.Action')); ?></th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($role->name); ?></td>
                <td><?php echo e($role->description); ?></td>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('group_permission')): ?>
                <?php if($role->id === 1): ?>
                <td><?php echo e(__('translate.Cannot_change_Default_Permissions')); ?></td>
                <?php else: ?>
                <td>
                  <a href="/user-management/permissions/<?php echo e($role->id); ?>/edit" class="cursor-pointer text-success ul-link-action"
                    data-toggle="tooltip" data-placement="top" title="Edit">
                    <i class="i-Edit"></i>
                  </a>
                  <a @click="Remove_role( <?php echo e($role->id); ?>)" class="cursor-pointer text-danger me-1 ul-link-action" data-toggle="tooltip"
                    data-placement="top" title="Delete">
                    <i class="i-Close-Window"></i>
                  </a>
                </td>
                <?php endif; ?>
                <?php endif; ?>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

          </table>
        </div>


      </div>
    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-js'); ?>

<script src="<?php echo e(asset('assets/js/vendor/datatables.min.js')); ?>"></script>


<script>
  var app = new Vue({
        el: '#section_Permissions_list',
        data: {
            SubmitProcessing:false,
            errors:[],
        },
       
        methods: {

             //--------------------------------- Remove Role ---------------------------\\
             Remove_role(id) {

                swal({
                    title: '<?php echo e(__('translate.Are_you_sure')); ?>',
                    text: '<?php echo e(__('translate.You_wont_be_able_to_revert_this')); ?>',
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#0CC27E',
                    cancelButtonColor: '#FF586B',
                    confirmButtonText: '<?php echo e(__('translate.Yes_delete_it')); ?>',
                    cancelButtonText: '<?php echo e(__('translate.No_cancel')); ?>',
                    confirmButtonClass: 'btn btn-primary me-5',
                    cancelButtonClass: 'btn btn-danger',
                    buttonsStyling: false
                }).then(function () {
                        axios
                            .delete("/user-management/permissions/" + id)
                            .then(() => {
                                window.location.href = '/user-management/permissions'; 
                                toastr.success('<?php echo e(__('translate.Deleted_in_successfully')); ?>');

                            })
                            .catch(() => {
                                toastr.error('<?php echo e(__('translate.There_was_something_wronge')); ?>');
                            });
                    });
                },





           
        },
        //-----------------------------Autoload function-------------------
        created() {
        }

    })

</script>

<script type="text/javascript">
  $(function () {
      "use strict";

        $('#permissions_table').DataTable( {
            "processing": true, // for show progress bar
            "responsive": true,
            dom: "<'row'<'col-sm-12 col-md-7'lB><'col-sm-12 col-md-5 p-0'f>>rtip",
            oLanguage: {
                    sEmptyTable: "<?php echo e(__('datatable.sEmptyTable')); ?>",
                    sInfo: "<?php echo e(__('datatable.sInfo')); ?>",
                    sInfoEmpty: "<?php echo e(__('datatable.sInfoEmpty')); ?>",
                    sInfoFiltered: "<?php echo e(__('datatable.sInfoFiltered')); ?>",
                    sInfoThousands: "<?php echo e(__('datatable.sInfoThousands')); ?>",
                    sLengthMenu: "_MENU_", 
                    sLoadingRecords: "<?php echo e(__('datatable.sLoadingRecords')); ?>",
                    sProcessing: "<?php echo e(__('datatable.sProcessing')); ?>",
                    sSearch: "",
                    sSearchPlaceholder: "<?php echo e(__('datatable.sSearchPlaceholder')); ?>",
                    oPaginate: {
                        sFirst: "<?php echo e(__('datatable.oPaginate.sFirst')); ?>",
                        sLast: "<?php echo e(__('datatable.oPaginate.sLast')); ?>",
                        sNext: "<?php echo e(__('datatable.oPaginate.sNext')); ?>",
                        sPrevious: "<?php echo e(__('datatable.oPaginate.sPrevious')); ?>",
                    },
                    oAria: {
                        sSortAscending: "<?php echo e(__('datatable.oAria.sSortAscending')); ?>",
                        sSortDescending: "<?php echo e(__('datatable.oAria.sSortDescending')); ?>",
                    }
                },
                buttons: [
                    {
                        extend: 'collection',
                        text: "<?php echo e(__('translate.EXPORT')); ?>",
                        buttons: [
                          {
                            extend: 'print',
                            text: 'print',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                          },
                          {
                            extend: 'pdf',
                            text: 'pdf',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                          },
                          {
                            extend: 'excel',
                            text: 'excel',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                          },
                          {
                            extend: 'csv',
                            text: 'csv',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                          },
                        ]
                      }]
        });

    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/itlabsys/public_html/niwethma.itlabsystems.lk/resources/views/permissions/permissions_list.blade.php ENDPATH**/ ?>