<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel=icon href=<?php echo e(asset('images/logo.svg')); ?>>

    <title><?php echo e(__('translate.Sign_in')); ?></title>
    <link href="https://fonts.googleapis.com/css?family=Nunito:300,400,400i,600,700,800,900" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/styles/css/themes/lite-purple.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/login_page.css')); ?>">

</head>


<body class="login-page">
    <div id="main-wrapper" class="show">

        <div class="login-posly">
            <div>
               
                <div class="login-main">
                   <form class="theme-form" id="form_login" method="POST" action="<?php echo e(route('login')); ?>">
                        <?php echo csrf_field(); ?>
                        <h4><?php echo e(__('translate.Sign_in_to_account')); ?></h4>
                        <p><?php echo e(__('translate.Enter_your_email_password_to_login')); ?></p>
                        <div class="form-group m-b-10">
                            <label class="col-form-label"><?php echo e(__('translate.Email_Address')); ?></label>
                            <input class="form-control" type="email" placeholder="Example@Example.com" <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email" autofocus>
                              <?php if($errors->has('email')): ?>
                                <span class="text-danger"><?php echo e($errors->first('email')); ?></span>
                              <?php elseif($errors->has('status')): ?>
                                <span class="text-danger"><?php echo e($errors->first('status')); ?></span>
                              <?php endif; ?>
                        </div>
                        <div class="form-group m-b-10">
                            <label class="col-form-label"><?php echo e(__('translate.Password')); ?></label>
                            <div class="form-input position-relative">
                                <input class="form-control" type="password" placeholder="*********" <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="password" required autocomplete="current-password">
                                <?php if($errors->has('password')): ?>
                                <span class="text-danger"><?php echo e($errors->first('password')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="form-group mb-0">
                            <div class="checkbox p-0">
                                <input id="checkbox1" type="checkbox">
                                <label class="text-muted" for="checkbox1"><?php echo e(__('translate.Remember_password')); ?></label>
                            </div>
                            <?php if(Route::has('password.request')): ?>

                                <div class="mt-3 text-center">

                                    <a href="<?php echo e(route('password.request')); ?>" class="link text-danger"><?php echo e(__('translate.Forgot_Password')); ?></a>
                                </div>
                            <?php endif; ?>

                            <div class="mt-3">
                            <button id="btn_submit" class="btn btn-primary w-100"><?php echo e(__('translate.Sign_in')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>

      <!-- JS Libraies -->
  <script src="<?php echo e(asset('/assets/js/jquery.js')); ?>"></script>
  <script src="<?php echo e(asset('/assets/js/popper.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/assets/js/bootstrap.min.js')); ?>"></script>
  <script src="<?php echo e(asset('/assets/js/scripts.js')); ?>"></script>
  <script src="<?php echo e(asset('/assets/js/custom.js')); ?>"></script>

  <script>
    $(function () {
      $("#form_login").one("submit", function () {
      //enter your submit code
      $("#btn_submit").prop('disabled', true);
      });
    });
  </script>
</body>
</html><?php /**PATH /home/itlabsys/public_html/niwethma.itlabsystems.lk/resources/views/auth/login.blade.php ENDPATH**/ ?>