
<?php $__env->startSection('main-content'); ?>
<?php $__env->startSection('page-css'); ?>

<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/nprogress.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/datepicker.min.css')); ?>">

<?php $__env->stopSection(); ?>

<div class="breadcrumb">
    <h1><?php echo e(__('translate.Payments_Purchase_Return')); ?></h1>
</div>

<div class="separator-breadcrumb border-top"></div>

<div class="row">
    <div class="col-md-12">
        <div class="text-left">
            <div class="text-end bg-transparent mb-3">

                <a class="btn btn-outline-primary btn-rounded btn-md m-1" id="Show_Modal_Filter"><i class="i-Filter-2 mr-2 font-weight-bold"></i>
                    <?php echo e(__('translate.Filter')); ?></a>
            </div>
                <div class="table-responsive">
                    <table id="payment_purchase_return_table" class="display table table-hover">
                        <thead>
                            <tr>
                                <th><?php echo e(__('translate.Date')); ?></th>
                                <th><?php echo e(__('translate.Ref')); ?></th>
                                <th><?php echo e(__('translate.Return')); ?></th>
                                <th><?php echo e(__('translate.Supplier')); ?></th>
                                <th><?php echo e(__('translate.Payment_Method')); ?></th>
                                <th><?php echo e(__('translate.Account')); ?></th>
                                <th><?php echo e(__('translate.Amount')); ?></th>
                            </tr>
                        </thead>
                        <tbody class="height_140">
                        </tbody>
                        <tfoot>
                            <tr>
                                <th><?php echo e(__('translate.Total')); ?></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
        </div>

         <!-- Modal Filter -->
         <div class="modal fade" id="filter_payment_purchase_return_modal" tabindex="-1" role="dialog"
         aria-labelledby="filter_payment_purchase_return_modal" aria-hidden="true">
         <div class="modal-dialog modal-lg" role="document">
             <div class="modal-content">
                 <div class="modal-header">
                     <h5 class="modal-title"><?php echo e(__('translate.Filter')); ?></h5>
                     <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                 </div>
                 <div class="modal-body">

                     <form method="POST" id="filter_payment_purchase_return">
                         <?php echo csrf_field(); ?>
                         <div class="row">

                             <div class="col-md-6">
                                 <label for="Ref" class="ul-form__label"><?php echo e(__('translate.Reference')); ?>

                                 </label>
                                 <input type="text" class="form-control" name="Ref" id="Ref"
                                     placeholder="<?php echo e(__('translate.Reference')); ?>">
                             </div>

                             <div class="col-md-6">
                                 <label for="provider_id" class="ul-form__label"><?php echo e(__('translate.Supplier')); ?>

                                 </label>
                                 <select name="provider_id" id="provider_id" class="form-control">
                                     <option value="0"><?php echo e(__('translate.All')); ?></option>
                                     <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                     <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->name); ?></option>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 </select>
                             </div>

                             <div class="col-md-6">
                                 <label for="purchase_return_id"
                                     class="ul-form__label"><?php echo e(__('translate.Return')); ?> </label>
                                 <select name="purchase_return_id" id="purchase_return_id" class="form-control">
                                     <option value="0"><?php echo e(__('translate.All')); ?></option>
                                     <?php $__currentLoopData = $purchase_returns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase_return): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                     <option value="<?php echo e($purchase_return->id); ?>"><?php echo e($purchase_return->Ref); ?></option>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 </select>
                             </div>

                             <div class="col-md-6">
                                 <label for="payment_method_id"
                                     class="ul-form__label"><?php echo e(__('translate.Payment_choice')); ?> </label>
                                 <select name="payment_method_id" id="payment_method_id" class="form-control">
                                     <option value="0"><?php echo e(__('translate.All')); ?></option>
                                     <?php $__currentLoopData = $payment_methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                     <option value="<?php echo e($payment_method->id); ?>"><?php echo e($payment_method->title); ?></option>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 </select>
                             </div>

                             <div class="col-md-6">
                                 <label for="account_id"
                                     class="ul-form__label"><?php echo e(__('translate.Account')); ?> </label>
                                 <select name="account_id" id="account_id" class="form-control">
                                     <option value="0"><?php echo e(__('translate.All')); ?></option>
                                     <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                     <option value="<?php echo e($account->id); ?>"><?php echo e($account->account_name); ?></option>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 </select>
                             </div>

                             <div class="col-md-6">
                                 <label for="start_date" class="ul-form__label"><?php echo e(__('translate.From_Date')); ?>

                                 </label>
                                 <input type="text" class="form-control date" name="start_date" id="start_date"
                                     placeholder="<?php echo e(__('translate.From_Date')); ?>" value="">
                             </div>

                             <div class="col-md-6">
                                 <label for="end_date" class="ul-form__label"><?php echo e(__('translate.To_Date')); ?> </label>
                                 <input type="text" class="form-control date" name="end_date" id="end_date"
                                     placeholder="<?php echo e(__('translate.To_Date')); ?>" value="">
                             </div>


                         </div>

                         <div class="row mt-3">

                            <div class="col-md-6">
                                <button type="submit" class="btn btn-primary">
                                  <i class="i-Filter-2 mr-2"></i> <?php echo e(__('translate.Filter')); ?>

                                </button>
                                <button id="Clear_Form" class="btn btn-danger">
                                  <i class="i-Power-2 mr-2"></i> <?php echo e(__('translate.Clear')); ?>

                                </button>
                              </div>
                         </div>


                     </form>

                 </div>

             </div>
         </div>
     </div>


    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-js'); ?>

<script src="<?php echo e(asset('assets/js/vendor/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datepicker.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/nprogress.js')); ?>"></script>

<script type="text/javascript">
    $(function () {
      "use strict";

      $(document).ready(function () {

        $("#start_date,#end_date").datepicker({
            format: 'yyyy-mm-dd',
            changeMonth: true,
            changeYear: true,
            autoclose: true,
            todayHighlight: true,
        });

        var end_date = new Date();
        var start_date = new Date();

        end_date.setDate(end_date.getDate() + 365);
        $("#end_date").datepicker("setDate" , end_date);

        start_date.setDate(start_date.getDate() - 365);
        $("#start_date").datepicker("setDate" , start_date);

        //init datatable
        payment_purchase_return_datatable();

      });


        //Get Data
        function payment_purchase_return_datatable(start_date ='', end_date ='', Ref ='', provider_id ='', purchase_return_id ='' , payment_method_id ='', account_id =''){
            var $symbol_placement = <?php echo json_encode($symbol_placement, 15, 512) ?>;
            var table = $('#payment_purchase_return_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?php echo e(route('payment_purchase_return_report')); ?>",
                    data: {
                        start_date: start_date === null?'':start_date,
                        end_date: end_date === null?'':end_date,
                        Ref: Ref === null?'':Ref,
                        payment_method_id: payment_method_id == '0'?'':payment_method_id,
                        account_id: account_id == '0'?'':account_id,
                        provider_id: provider_id == '0'?'':provider_id,
                        purchase_return_id: purchase_return_id == '0'?'':purchase_return_id,
                        "_token": "<?php echo e(csrf_token()); ?>"
                    },
                },
                columns: [
                    {data: 'date', name: 'date'},
                    {data: 'Ref', name: 'Ref'},
                    {data: 'Ref_return', name: 'Ref_return'},
                    {data: 'provider_name', name: 'provider_name'},
                    {data: 'Reglement', name: 'Reglement'},
                    {data: 'account_name', name: 'account_name'},
                    {data: 'montant', name: 'montant'},
                ],

                footerCallback: function (row, data, start, end, display) {
                    var api = this.api();
        
                    // Remove the formatting to get integer data for summation
                    var intVal = function (i) {
                        return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                    };
        
                    // Total over this page
                    var total_amount = api.column(6, { page: 'current' }).data().reduce(function (a, b) {
                            return intVal(a) + intVal(b);
                        }, 0);

                     // Update footer
                     var numberRenderer = $.fn.dataTable.render.number(',', '.', 2).display;

                    if ($symbol_placement == 'before') {
                        $(api.column(6).footer()).html('<?php echo e($currency); ?>' +' '+ numberRenderer(total_amount));

                    }else{
                        $(api.column(6).footer()).html(numberRenderer(total_amount) +' '+ '<?php echo e($currency); ?>');

                    }
                },
            
                lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
                dom: "<'row'<'col-sm-12 col-md-7'lB><'col-sm-12 col-md-5 p-0'f>>rtip",
                oLanguage: {
                    sEmptyTable: "<?php echo e(__('datatable.sEmptyTable')); ?>",
                    sInfo: "<?php echo e(__('datatable.sInfo')); ?>",
                    sInfoEmpty: "<?php echo e(__('datatable.sInfoEmpty')); ?>",
                    sInfoFiltered: "<?php echo e(__('datatable.sInfoFiltered')); ?>",
                    sInfoThousands: "<?php echo e(__('datatable.sInfoThousands')); ?>",
                    sLengthMenu: "_MENU_", 
                    sLoadingRecords: "<?php echo e(__('datatable.sLoadingRecords')); ?>",
                    sProcessing: "<?php echo e(__('datatable.sProcessing')); ?>",
                    sSearch: "",
                    sSearchPlaceholder: "<?php echo e(__('datatable.sSearchPlaceholder')); ?>",
                    oPaginate: {
                        sFirst: "<?php echo e(__('datatable.oPaginate.sFirst')); ?>",
                        sLast: "<?php echo e(__('datatable.oPaginate.sLast')); ?>",
                        sNext: "<?php echo e(__('datatable.oPaginate.sNext')); ?>",
                        sPrevious: "<?php echo e(__('datatable.oPaginate.sPrevious')); ?>",
                    },
                    oAria: {
                        sSortAscending: "<?php echo e(__('datatable.oAria.sSortAscending')); ?>",
                        sSortDescending: "<?php echo e(__('datatable.oAria.sSortDescending')); ?>",
                    }
                },
                buttons: [
                    {
                        extend: 'collection',
                        text: "<?php echo e(__('translate.EXPORT')); ?>",
                        buttons: [
                          {
                            extend: 'print',
                            text: 'Print',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                return 'Report Payment Purchase return';
                            },
                          },
                          {
                            extend: 'pdf',
                            text: 'Pdf',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                              return 'Report Payment Purchase return';
                            },
                           
                        },
                          {
                            extend: 'excel',
                            text: 'Excel',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                              return 'Report Payment Purchase return';
                            },
                          },
                          {
                            extend: 'csv',
                            text: 'Csv',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                              return 'Report Payment Purchase return';
                            },
                          },
                        ]
                }],
            });
        }

        // Clear Filter

        $('#Clear_Form').on('click' , function (e) {
            var end_date = new Date();
            var start_date = new Date();

            end_date.setDate(end_date.getDate() + 365);
            $("#end_date").datepicker("setDate" , end_date);

            start_date.setDate(start_date.getDate() - 365);
            $("#start_date").datepicker("setDate" , start_date);

            var Ref = $('#Ref').val('');
            var payment_method_id = $('#payment_method_id').val('0');
            var account_id = $('#account_id').val('0');
            let provider_id = $('#provider_id').val('0');
            let purchase_return_id = $('#purchase_return_id').val('0');

        });


         // Show Modal Filter
        $('#Show_Modal_Filter').on('click' , function (e) {
            $('#filter_payment_purchase_return_modal').modal('show');
        });


         // Submit Filter
        $('#filter_payment_purchase_return').on('submit' , function (e) {
            e.preventDefault();
            var start_date = $('#start_date').val();
            var end_date = $('#end_date').val();
            var Ref = $('#Ref').val();
            var payment_method_id = $('#payment_method_id').val();
            var account_id = $('#account_id').val();
            let provider_id = $('#provider_id').val();
            let purchase_return_id = $('#purchase_return_id').val();
      
            $('#payment_purchase_return_table').DataTable().destroy();
            payment_purchase_return_datatable(start_date, end_date, Ref, provider_id, purchase_return_id , payment_method_id, account_id);

            $('#filter_payment_purchase_return_modal').modal('hide');
           
        });

         

      
    });
</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/itlabsys/public_html/niwethma.itlabsystems.lk/resources/views/reports/payment_purchase_return.blade.php ENDPATH**/ ?>