
<?php $__env->startSection('main-content'); ?>
<?php $__env->startSection('page-css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/nprogress.css')); ?>">
<?php $__env->stopSection(); ?>

<div class="breadcrumb">
  <h1><?php echo e(__('translate.User_Controller')); ?></h1>
</div>

<div class="separator-breadcrumb border-top"></div>

<div id="section_User_list">
  <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-md-12">
          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_add')): ?>
          <div class="text-end mb-3">
            <a class="new_user btn btn-outline-primary btn-md m-1" @click="New_User"><i class="i-Add me-2 font-weight-bold"></i></i>
              <?php echo e(__('translate.Create')); ?></a>
          </div>
          <?php endif; ?>
          <div class="table-responsive">
            <table id="ul-contact-list" class="display table">
              <thead>
                <tr>
                  <th><?php echo e(__('translate.Avatar')); ?></th>
                  <th><?php echo e(__('translate.Username')); ?></th>
                  <th><?php echo e(__('translate.Email')); ?></th>
                  <th><?php echo e(__('translate.Status')); ?></th>
                  <th><?php echo e(__('translate.Role')); ?></th>
                  <th><?php echo e(__('translate.Assign_Role')); ?></th>
                  <th><?php echo e(__('translate.Action')); ?></th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td>
                    <div class="avatar me-2 avatar-md">
                      <img src="<?php echo e(asset('images/avatar/'.$user->avatar)); ?>" alt="">
                    </div>
                  </td>
                  <td><?php echo e($user->username); ?></td>
                  <td><?php echo e($user->email); ?></td>
                  <td>
                    <?php if($user->status): ?>
                    <span class="badge badge-success m-2"><?php echo e(__('translate.Active')); ?></span>
                    <?php else: ?>
                    <span class="badge badge-danger m-2"><?php echo e(__('translate.Inactive')); ?></span>
                    <?php endif; ?>
                  </td>
                  <td><?php echo e($user->RoleUser['name']); ?></td>
                  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('group_permission')): ?>
                  <?php if($user->role_users_id === 1): ?>
                  <td><?php echo e(__('translate.Cannot_change_Default_Permissions')); ?></td>
                  <?php else: ?>
                  <td>
                    <div class="dropdown">
                      <button class="btn btn-primary btn-sm m-1 dropdown-toggle" type="button" id="assignRole"
                        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <?php echo e(__('translate.Assign_Role')); ?>

                      </button>
                      <div class="dropdown-menu" aria-labelledby="assignRole">
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a class="dropdown-item cursor-pointer"
                          @click="assignRole( <?php echo e($user->id); ?> , <?php echo e($role->id); ?>)"><?php echo e($role->name); ?></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </div>
                    </div>
                  </td>
                  <?php endif; ?>

                  <?php endif; ?>

                  <td>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_edit')): ?>
                    <a @click="Edit_User( <?php echo e($user); ?>)" class="cursor-pointer text-success ul-link-action" data-toggle="tooltip"
                      data-placement="top" title="Edit">
                      <i class="i-Edit"></i>
                    </a>
                    <?php endif; ?>

                    <?php if(auth()->user()->can('user_delete') && Auth::user()->id !== $user->id): ?>
                    <a @click="Remove_User( <?php echo e($user->id); ?>)" class="cursor-pointer text-danger me-1 ul-link-action"
                      data-toggle="tooltip" data-placement="top" title="Delete">
                      <i class="i-Close-Window"></i>
                    </a>
                    <?php endif; ?>

                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>

            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal Add & Edit User -->
  <div class="modal fade" id="user_Modal" tabindex="-1" role="dialog" aria-labelledby="user_Modal" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 v-if="editmode" class="modal-title" id="user_Modal"><?php echo e(__('translate.Edit')); ?></h5>
          <h5 v-else class="modal-title" id="user_Modal"><?php echo e(__('translate.Create')); ?></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">

          <form @submit.prevent="editmode?Update_User():Create_User()" enctype="multipart/form-data">
            <div class="row">

              <div class="form-group col-md-6">
                <label for="username"><?php echo e(__('translate.FullName')); ?><span class="field_required">*</span></label>
                <input type="text" v-model="user.username" class="form-control" name="username" id="username"
                  placeholder="<?php echo e(__('translate.Enter_FullName')); ?>">
                <span class="error" v-if="errors && errors.username">
                  {{ errors.username[0] }}
                </span>
              </div>

              <div class="form-group col-md-6">
                <label for="email"><?php echo e(__('translate.Email_Address')); ?><span class="field_required">*</span></label>
                <input type="text" v-model="user.email" class="form-control" name="email" id="email"
                  placeholder="<?php echo e(__('translate.Enter_email_address')); ?>">
                <span class="error" v-if="errors && errors.email">
                  {{ errors.email[0] }}
                </span>
              </div>

              <div class="form-group col-md-6">
                <label for="password"><?php echo e(__('translate.Password')); ?> <span class="field_required">*</span></label>
                <input type="password" v-model="user.password" class="form-control" id="password"
                  placeholder="<?php echo e(__('translate.min_6_characters')); ?>">
                <span class="error" v-if="errors && errors.password">
                  {{ errors.password[0] }}
                </span>
              </div>

              <div class="form-group col-md-6">
                <label for="password_confirmation"><?php echo e(__('translate.Repeat_Password')); ?>

                  <span class="field_required">*</span></label>
                <input type="password" v-model="user.password_confirmation" class="form-control"
                  id="password_confirmation" placeholder="<?php echo e(__('translate.Repeat_Password')); ?>">
                <span class="error" v-if="errors && errors.password_confirmation">
                  {{ errors.password_confirmation[0] }}
                </span>
              </div>

              <div class="form-group col-md-6" v-if="auth_user_id !== user.id">
                <label><?php echo e(__('translate.Status')); ?> <span class="field_required">*</span></label>
                <v-select @input="Selected_Status" placeholder="<?php echo e(__('translate.Choose_status')); ?>"
                  v-model="user.status" :reduce="(option) => option.value" :options="
                                                 [
                                                     {label: 'Active', value: 1},
                                                     {label: 'Inactive', value: 0},
                                                 ]">
                </v-select>

                <span class="error" v-if="errors && errors.status">
                  {{ errors.status[0] }}
                </span>
              </div>

              <div class="form-group col-md-6" v-if="!editmode">
                <label><?php echo e(__('translate.Role')); ?> <span class="field_required">*</span></label>
                <v-select @input="Selected_Role" placeholder="<?php echo e(__('translate.Choose_Role')); ?>"
                  v-model="user.role_users_id" :reduce="(option) => option.value"
                  :options="roles.map(roles => ({label: roles.name, value: roles.id}))">
                </v-select>

                <span class="error" v-if="errors && errors.role_users_id">
                  {{ errors.role_users_id[0] }}
                </span>
              </div>

              <div class="form-group col-md-6">
                <label for="Avatar"><?php echo e(__('translate.Avatar')); ?></label>
                <input name="Avatar" @change="changeAvatar" type="file" class="form-control" id="Avatar">
                <span class="error" v-if="errors && errors.avatar">
                  {{ errors.avatar[0] }}
                </span>
              </div>

              <hr/>

              <div class="form-group col-md-12">
                  <h5><?php echo e(__('translate.Assigned_warehouses')); ?></h5>
                  <div class="form-check form-check-inline w-15">
                    <input class="form-check-input" type="checkbox" id="is_all_warehouses" v-model="user.is_all_warehouses">
                    <label class="form-check-label" for="is_all_warehouses"><?php echo e(__('translate.All_Warehouses')); ?></label>
                  </div>
                  <v-select
                      multiple
                      v-model="assigned_warehouses"
                      @input="Selected_Warehouse"
                      :reduce="label => label.value"
                      placeholder="<?php echo e(__('translate.PleaseSelect')); ?>"
                      :options="warehouses.map(warehouses => ({label: warehouses.name, value: warehouses.id}))">
                  </v-select>
                </div>

            </div>
            <div class="row mt-3">

              <div class="col-md-6">
                <button type="submit" class="btn btn-primary" :disabled="SubmitProcessing">
                  <span v-if="SubmitProcessing" class="spinner-border spinner-border-sm" role="status"
                    aria-hidden="true"></span> <i class="i-Yes me-2 font-weight-bold"></i> <?php echo e(__('translate.Submit')); ?>

                </button>
              </div>
            </div>


          </form>

        </div>

      </div>
    </div>
  </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-js'); ?>

<script src="<?php echo e(asset('assets/js/vendor/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/nprogress.js')); ?>"></script>

<script>
  var auth_user_id = <?php echo json_encode(Auth::user()->id); ?>;
</script>

<script type="text/javascript">
  $(function () {
    "use strict";

      $('#ul-contact-list').DataTable( {
          "processing": true, // for show progress bar
          lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
          dom: "<'row'<'col-sm-12 col-md-7'lB><'col-sm-12 col-md-5 p-0'f>>rtip",
          oLanguage: {
                sEmptyTable: "<?php echo e(__('datatable.sEmptyTable')); ?>",
                sInfo: "<?php echo e(__('datatable.sInfo')); ?>",
                sInfoEmpty: "<?php echo e(__('datatable.sInfoEmpty')); ?>",
                sInfoFiltered: "<?php echo e(__('datatable.sInfoFiltered')); ?>",
                sInfoThousands: "<?php echo e(__('datatable.sInfoThousands')); ?>",
                sLengthMenu: "_MENU_", 
                sLoadingRecords: "<?php echo e(__('datatable.sLoadingRecords')); ?>",
                sProcessing: "<?php echo e(__('datatable.sProcessing')); ?>",
                sSearch: "",
                sSearchPlaceholder: "<?php echo e(__('datatable.sSearchPlaceholder')); ?>",
                oPaginate: {
                    sFirst: "<?php echo e(__('datatable.oPaginate.sFirst')); ?>",
                    sLast: "<?php echo e(__('datatable.oPaginate.sLast')); ?>",
                    sNext: "<?php echo e(__('datatable.oPaginate.sNext')); ?>",
                    sPrevious: "<?php echo e(__('datatable.oPaginate.sPrevious')); ?>",
                },
                oAria: {
                    sSortAscending: "<?php echo e(__('datatable.oAria.sSortAscending')); ?>",
                    sSortDescending: "<?php echo e(__('datatable.oAria.sSortDescending')); ?>",
                }
            },
                buttons: [
                    {
                        extend: 'collection',
                        text: "<?php echo e(__('translate.EXPORT')); ?>",
                        buttons: [
                          {
                            extend: 'print',
                            text: 'print',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                  return 'Users List';
                            },
                          },
                          {
                            extend: 'pdf',
                            text: 'pdf',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                  return 'Users List';
                            },
                          },
                          {
                            extend: 'excel',
                            text: 'excel',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                  return 'Users List';
                            },
                          },
                          {
                            extend: 'csv',
                            text: 'csv',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                  return 'Users List';
                            },
                          },
                        ]
                    }]
      });
  });
</script>

<script>
  Vue.component('v-select', VueSelect.VueSelect)

        var app = new Vue({
        el: '#section_User_list',
        data: {
            data: new FormData(),
            editmode: false,
            SubmitProcessing:false,
            errors:[],
            roles: <?php echo json_encode($roles, 15, 512) ?>, 
            warehouses: <?php echo json_encode($warehouses, 15, 512) ?>, 
            assigned_warehouses : [],
            users: {}, 
            user: {
                username: "",
                password: "",
                password_confirmation:"",
                is_all_warehouses:1,
                email: "",
                status: 1,
                avatar: "",
                role_users_id: "",
            }, 
            old_photo: '',
        },
       
        methods: {



            Selected_Status(value) {
                if (value === null) {
                    this.user.status = "";
                }
            },

            Selected_Role(value) {
                if (value === null) {
                    this.user.role_users_id = "";
                }
            },

            Selected_Warehouse(value) {
                if (!value.length) {
                    this.assigned_warehouses = [];
                }
            },


            //------------------------------ Show Modal (Create User) -------------------------------\\
            New_User() {
                this.reset_Form();
                this.editmode = false;
                this.Get_Data_Create();
                $('#user_Modal').modal('show');
            },

            //------------------------------ Show Modal (Update User) -------------------------------\\
            Edit_User(user) {
                this.editmode = true;
                this.reset_Form();
                this.Get_Data_Edit(user.id);
                setTimeout(() => {
                  $('#user_Modal').modal('show');
                }, 800);
            },

            changeAvatar(e){
                let file = e.target.files[0];
                this.user.avatar = file;
            },

            //----------------------------- Reset Form ---------------------------\\
            reset_Form() {
                this.user = {
                    id: "",
                    username: "",
                    password: "",
                    password_confirmation:"",
                    is_all_warehouses:1,
                    email: "",
                    status: 1,
                    avatar: "",
                    role_users_id: "",
                };
                this.errors = {};
                this.assigned_warehouses = [];
            },

             //---------------------- Get_Data_Create  ------------------------------\\
             Get_Data_Create() {
                axios
                    .get("/user-management/users/create")
                    .then(response => {
                        this.roles   = response.data;
                    })
                    .catch(error => {
                       
                    });
            },

               //---------------------- Get_Data_Edit  ------------------------------\\
               Get_Data_Edit(id) {
                axios
                    .get("/user-management/users/"+id+"/edit")
                    .then(response => {
                        this.user   = response.data.User;
                        this.old_photo = this.user.avatar;
                        this.user.password =  "";
                        this.user.password_confirmation = "";
                        this.assigned_warehouses   = response.data.assigned_warehouses;
                    })
                    .catch(error => {
                       
                    });
            },

            //----------------------- assignRole ---------------------------\\

            assignRole(user_id , role_id) {
                var self = this;
                axios.post("/user-management/assignRole", {
                    user_id: user_id,
                    role_id: role_id,
                }).then(response => {
                       window.location.href = '/user-management/users'; 
                        toastr.success('<?php echo e(__('translate.Updated_in_successfully')); ?>');
                        self.errors = {};
                    })
                    .catch(error => {
                        if (error.response.status == 422) {
                            self.errors = error.response.data.errors;
                        }
                        toastr.error('<?php echo e(__('translate.There_was_something_wronge')); ?>');
                    });
            },

            
            //------------------------ Create User ---------------------------\\
            Create_User() {
                var self = this;
                self.SubmitProcessing = true;
                self.data.append("username", self.user.username);
                self.data.append("email", self.user.email);
                self.data.append("password", self.user.password);
                self.data.append("password_confirmation", self.user.password_confirmation);
                self.data.append("status", self.user.status);
                self.data.append("avatar", self.user.avatar);
                self.data.append("role_users_id", self.user.role_users_id);
                self.data.append("is_all_warehouses", self.user.is_all_warehouses);

                // append array assigned_warehouses
                if (self.assigned_warehouses.length) {
                  for (var i = 0; i < self.assigned_warehouses.length; i++) {
                    self.data.append("assigned_to[" + i + "]", self.assigned_warehouses[i]);
                  }
                }else{
                  self.data.append("assigned_to", []);
                }

                axios
                    .post("/user-management/users", self.data)
                    .then(response => {
                        self.SubmitProcessing = false;
                        window.location.href = '/user-management/users'; 
                        toastr.success('<?php echo e(__('translate.Created_in_successfully')); ?>');
                        self.errors = {};
                })
                .catch(error => {
                    self.SubmitProcessing = false;
                    if (error.response.status == 422) {
                        self.errors = error.response.data.errors;
                    }
                    toastr.error('<?php echo e(__('translate.There_was_something_wronge')); ?>');
                });
            },

           //----------------------- Update User ---------------------------\\
            Update_User() {
                var self = this;
                self.SubmitProcessing = true;
                self.data.append("username", self.user.username);
                self.data.append("email", self.user.email);
                self.data.append("password", self.user.password);
                self.data.append("password_confirmation", self.user.password_confirmation);
                self.data.append("status", self.user.status);
                self.data.append("is_all_warehouses", self.user.is_all_warehouses);

                if(self.old_photo != self.user.avatar){
                 self.data.append("avatar", self.user.avatar);
                }

                // append array assigned_warehouses
                if (self.assigned_warehouses.length) {
                  for (var i = 0; i < self.assigned_warehouses.length; i++) {
                    self.data.append("assigned_to[" + i + "]", self.assigned_warehouses[i]);
                  }
                }else{
                  self.data.append("assigned_to", []);
                }

                self.data.append("_method", "put");

                axios
                    .post("/user-management/users/" + this.user.id, self.data)
                    .then(response => {
                        self.SubmitProcessing = false;
                        $.event.trigger('event_users');
                        window.location.href = '/user-management/users'; 
                        toastr.success('<?php echo e(__('translate.Updated_in_successfully')); ?>');
                        self.errors = {};
                    })
                    .catch(error => {
                        self.SubmitProcessing = false;
                        if (error.response.status == 422) {
                            self.errors = error.response.data.errors;
                        }
                        toastr.error('<?php echo e(__('translate.There_was_something_wronge')); ?>');
                    });
            },

             //--------------------------------- Remove User ---------------------------\\
            Remove_User(id) {

                swal({
                    title: '<?php echo e(__('translate.Are_you_sure')); ?>',
                    text: '<?php echo e(__('translate.You_wont_be_able_to_revert_this')); ?>',
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#0CC27E',
                    cancelButtonColor: '#FF586B',
                    confirmButtonText: '<?php echo e(__('translate.Yes_delete_it')); ?>',
                    cancelButtonText: '<?php echo e(__('translate.No_cancel')); ?>',
                    confirmButtonClass: 'btn btn-primary me-5',
                    cancelButtonClass: 'btn btn-danger',
                    buttonsStyling: false
                }).then(function () {
                        axios
                            .delete("/user-management/users/" + id)
                            .then(() => {
                              window.location.href = '/user-management/users'; 
                              toastr.success('<?php echo e(__('translate.Deleted_in_successfully')); ?>');

                            })
                            .catch(() => {
                                toastr.error('<?php echo e(__('translate.There_was_something_wronge')); ?>');
                            });
                    });
                },





           
        },
        //-----------------------------Autoload function-------------------
        created() {
        }

    })

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/itlabsys/public_html/niwethma.itlabsystems.lk/resources/views/user/user_list.blade.php ENDPATH**/ ?>