
<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-12 text-center mt-3">
            <ul class="progressbar">
                <li class="active"><a href="/setup"><?php echo e(__('translate.Server_Requirements')); ?></a></li>
                <li class="active"><a href="/setup/step-1"><?php echo e(__('translate.Settings')); ?></a></li>
                <li><?php echo e(__('translate.Database')); ?></li>
                <li><?php echo e(__('translate.Summary')); ?></li>
            </ul>
        </div>
    </div>

    <div class="row mt-3 p-5">
        <div class="col-12">
            <form action="<?php echo e(route('setupStep1')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label for="app_name"><?php echo e(__('translate.Name_your_Application')); ?></label> <span class="tip" title="<?php echo e(__('translate.This is the name of your Application')); ?>"><i class="fa fa-question-circle" aria-hidden="true"></i></span>
                    <input type="text" class="form-control" id="app_name" name="app_name" placeholder="<?php echo e(__('translate.Name_your_Application')); ?>"  value="<?php echo e($data['APP_NAME']); ?>" autofocus>
                </div>

                <div class="form-group">
                    <label for="app_env"><?php echo e(__('translate.Select_Environment')); ?></label> <span class="tip" title="<?php echo e(__('translate.The environment you want to deploy to. For coding you usually want to use local')); ?>"><i class="fa fa-question-circle" aria-hidden="true"></i></span>
                    <select class="form-control" id="app_env" name="app_env">
                        <?php if($data['APP_ENV'] == 'local'): ?>
                            <option value="local"><?php echo e(__('translate.Local')); ?></option>
                            <option value="testing"><?php echo e(__('translate.Testing')); ?></option>
                            <option value="production"><?php echo e(__('translate.Production')); ?></option>
                        <?php elseif($data['APP_ENV'] == 'testing'): ?>
                            <option value="testing"><?php echo e(__('translate.Testing')); ?></option>
                            <option value="local"><?php echo e(__('translate.Local')); ?></option>
                            <option value="production"><?php echo e(__('translate.Production')); ?></option>
                        <?php else: ?>
                            <option value="production"><?php echo e(__('translate.Production')); ?></option>
                            <option value="testing"><?php echo e(__('translate.Testing')); ?></option>
                            <option value="local"><?php echo e(__('translate.Local')); ?></option>
                        <?php endif; ?>

                    </select>
                </div>

                <div class="form-group">
                    <label for="app_debug"><?php echo e(__('translate.App_Debug_Mode')); ?></label> <span class="tip" title="<?php echo e(__('translate.APP_DEBUG offers error reporting for development purpose')); ?>"><i class="fa fa-question-circle" aria-hidden="true"></i></span>
                    <select class="form-control" id="app_debug" name="app_debug">
                        <?php if($data['APP_DEBUG'] == 'true'): ?>
                        <option value="true"><?php echo e(__('translate.Debug_Mode_true')); ?></option>
                        <option value="false"><?php echo e(__('translate.Debug_Mode_false')); ?></option>
                        <?php else: ?>
                            <option value="false"><?php echo e(__('translate.Debug_Mode_false')); ?></option>
                            <option value="true"><?php echo e(__('translate.Debug_Mode_true')); ?></option>
                        <?php endif; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="app_name"><?php echo e(__('translate.App_Key')); ?></label> <span class="tip" title="<?php echo e(__('translate.The application key is a unique base64 String. Click if you want a new one for your application')); ?>"><i class="fa fa-question-circle" aria-hidden="true"></i></span>
                    <input type="text" class="form-control" id="app_key" name="app_key"   value="<?php echo e($data['APP_KEY']); ?>" 
                    placeholder="<?php echo e(__('translate.Click_Button_to_generate')); ?>" readonly>

                    <div class="col-12 col-md-6">
                        <button class="btn btn-outline-warning mt-3" id="generate_key" title="<?php echo e(__('translate.Generate_Key')); ?>"><?php echo e(__('translate.Generate_Key')); ?></button>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12 col-md-6">
                         <a href="/setup" class="btn btn-outline-danger  mt-3"  ><i class="fa fa-angle-left"></i><?php echo e(__('translate.Previous_Step')); ?> </a>
                    </div>
                   <div class="col-6 col-md-6">
                        <button type="submit" id="next"  class="btn btn-outline-danger mt-3 float-md-right" ><?php echo e(__('translate.Next_Step')); ?> <i class="fa fa-angle-right"></i></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('setup.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/itlabsys/public_html/niwethma.itlabsystems.lk/resources/views/setup/step1.blade.php ENDPATH**/ ?>