
<?php $__env->startSection('main-content'); ?>
<?php $__env->startSection('page-css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/nprogress.css')); ?>">
<?php $__env->stopSection(); ?>

<div class="breadcrumb">
    <h1><?php echo e(__('translate.ProductQuantityAlerts')); ?></h1>
</div>

<div class="separator-breadcrumb border-top"></div>


<div id="alert_quantity">
    <div class="row">
        <div class="form-group col-md-6">
            <label for="warehouse_id"><?php echo e(__('translate.warehouse')); ?>

            </label>
            <select name="warehouse_id" id="warehouse_id" class="form-control">
                <option value="0"><?php echo e(__('translate.All')); ?></option>
                <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($warehouse->id); ?>"><?php echo e($warehouse->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                        
                    <div class="table-responsive">
                        <table id="quantity_alerts_table" class="display table table-hover">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('translate.Code')); ?></th>
                                    <th><?php echo e(__('translate.Name')); ?></th>
                                    <th><?php echo e(__('translate.warehouse')); ?></th>
                                    <th><?php echo e(__('translate.Current_Stock')); ?></th>
                                    <th><?php echo e(__('translate.Stock_Alert')); ?></th>
                                </tr>
                            </thead>
                            <tbody class="height_140">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-js'); ?>

<script src="<?php echo e(asset('assets/js/vendor/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/nprogress.js')); ?>"></script>


<script type="text/javascript">
    $(function() {
        "use strict";

        $(document).ready(function () {
          //init datatable
          quantity_alerts_datatable();
        });


            //Get Data
            function quantity_alerts_datatable(warehouse_id = ''){
                var table = $('#quantity_alerts_table').DataTable({
                    processing: true,
                    serverSide: true,
                    "order": [[ 0, "desc" ]],
                    ajax: {
                        url: "<?php echo e(route('reports_quantity_alerts')); ?>",
                        data: {
                            warehouse_id: warehouse_id == '0'?'':warehouse_id,

                            "_token": "<?php echo e(csrf_token()); ?>"
                        },
                    },
                    columns: [
                        {data: 'product_code', name: 'product_code'},
                        {data: 'product_name', name: 'product_name'},
                        {data: 'warehouse_name', name: 'warehouse_name'},
                        {data: 'current_stock', name: 'current_stock'},
                        {data: 'stock_alert', name: 'stock_alert'},
                    ],
                
                    lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
                    dom: "<'row'<'col-sm-12 col-md-7'lB><'col-sm-12 col-md-5 p-0'f>>rtip",
                    oLanguage: {
                        sEmptyTable: "<?php echo e(__('datatable.sEmptyTable')); ?>",
                        sInfo: "<?php echo e(__('datatable.sInfo')); ?>",
                        sInfoEmpty: "<?php echo e(__('datatable.sInfoEmpty')); ?>",
                        sInfoFiltered: "<?php echo e(__('datatable.sInfoFiltered')); ?>",
                        sInfoThousands: "<?php echo e(__('datatable.sInfoThousands')); ?>",
                        sLengthMenu: "_MENU_", 
                        sLoadingRecords: "<?php echo e(__('datatable.sLoadingRecords')); ?>",
                        sProcessing: "<?php echo e(__('datatable.sProcessing')); ?>",
                        sSearch: "",
                        sSearchPlaceholder: "<?php echo e(__('datatable.sSearchPlaceholder')); ?>",
                        oPaginate: {
                            sFirst: "<?php echo e(__('datatable.oPaginate.sFirst')); ?>",
                            sLast: "<?php echo e(__('datatable.oPaginate.sLast')); ?>",
                            sNext: "<?php echo e(__('datatable.oPaginate.sNext')); ?>",
                            sPrevious: "<?php echo e(__('datatable.oPaginate.sPrevious')); ?>",
                        },
                        oAria: {
                            sSortAscending: "<?php echo e(__('datatable.oAria.sSortAscending')); ?>",
                            sSortDescending: "<?php echo e(__('datatable.oAria.sSortDescending')); ?>",
                        }
                    },
                    buttons: [
                    {
                        extend: 'collection',
                        text: "<?php echo e(__('translate.EXPORT')); ?>",
                        buttons: [
                          {
                            extend: 'print',
                            text: 'Print',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                return 'Report Quantity alert';
                            },
                          },
                          {
                            extend: 'pdf',
                            text: 'Pdf',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                              return 'Report Quantity alert';
                            },
                           
                        },
                          {
                            extend: 'excel',
                            text: 'Excel',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                              return 'Report Quantity alert';
                            },
                          },
                          {
                            extend: 'csv',
                            text: 'Csv',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                              return 'Report Quantity alert';
                            },
                          },
                        ]
                }],
                });
            }

               // Submit Filter
           $('#warehouse_id').on('change' , function (e) {

                let warehouse_id = $('#warehouse_id').val();

                $('#quantity_alerts_table').DataTable().destroy();
                quantity_alerts_datatable(warehouse_id);

            });

      
    });
</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/itlabsys/public_html/niwethma.itlabsystems.lk/resources/views/reports/reports_quantity_alerts.blade.php ENDPATH**/ ?>