
<?php $__env->startSection('main-content'); ?>
<?php $__env->startSection('page-css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/nprogress.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/datepicker.min.css')); ?>">
<?php $__env->stopSection(); ?>


<div class="breadcrumb">
  <h1><?php echo e(__('translate.ListTransfers')); ?></h1>
</div>

<div class="separator-breadcrumb border-top"></div>

<div id="section_transfer_list">
  <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-md-12">
          <div class="text-end mb-3">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transfer_add')): ?>
            <a href="/transfer/transfers/create" class="btn btn-outline-primary btn-md m-1"><i class="i-Add me-2 font-weight-bold"></i>
              <?php echo e(__('translate.Create')); ?></a>
            <?php endif; ?>
            <a class="btn btn-outline-success btn-md m-1" id="Show_Modal_Filter"><i class="i-Filter-2 me-2 font-weight-bold"></i>
              <?php echo e(__('translate.Filter')); ?></a>
          </div>

          <div class="table-responsive">
            <table id="transfer_table" class="display table">
              <thead>
                <tr>
                  <th>ID</th>
                  <th><?php echo e(__('translate.Date')); ?></th>
                  <th><?php echo e(__('translate.Ref')); ?></th>
                  <th><?php echo e(__('translate.From_Warehouse')); ?></th>
                  <th><?php echo e(__('translate.To_Warehouse')); ?></th>
                  <th><?php echo e(__('translate.Total_Products')); ?></th>
                  <th><?php echo e(__('translate.Total')); ?></th>
                  <th class="not_show"><?php echo e(__('translate.Action')); ?></th>
                </tr>
              </thead>
              <tbody>
              </tbody>

            </table>
          </div>



        </div>
      </div>
    </div>
  </div>


  <!-- Modal Filter -->
  <div class="modal fade" id="filter_transfer_modal" tabindex="-1" role="dialog" aria-labelledby="filter_transfer_modal"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title"><?php echo e(__('translate.Filter')); ?></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">

          <form method="POST" id="filter_transfer">
            <?php echo csrf_field(); ?>
            <div class="row">

              <div class="form-group col-md-6">
                <label for="start_date"><?php echo e(__('translate.From_Date')); ?>

                </label>
                <input type="text" class="form-control date" name="start_date" id="start_date"
                  placeholder="<?php echo e(__('translate.From_Date')); ?>" value="">
              </div>

              <div class="form-group col-md-6">
                <label for="end_date"><?php echo e(__('translate.To_Date')); ?> </label>
                <input type="text" class="form-control date" name="end_date" id="end_date"
                  placeholder="<?php echo e(__('translate.To_Date')); ?>" value="">
              </div>

              <div class="form-group col-md-6">
                <label for="Ref"><?php echo e(__('translate.Reference')); ?>

                </label>
                <input type="text" class="form-control" name="Ref" id="Ref"
                  placeholder="<?php echo e(__('translate.Reference')); ?>">
              </div>

              <div class="form-group col-md-6">
                <label for="from_warehouse_id"><?php echo e(__('translate.From_warehouse')); ?>

                </label>
                <select name="from_warehouse_id" id="from_warehouse_id" class="form-control">
                  <option value="0"><?php echo e(__('translate.All')); ?></option>
                  <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($warehouse->id); ?>"><?php echo e($warehouse->name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>

              <div class="form-group col-md-6">
                <label for="to_warehouse_id"><?php echo e(__('translate.To_warehouse')); ?>

                </label>
                <select name="to_warehouse_id" id="to_warehouse_id" class="form-control">
                  <option value="0"><?php echo e(__('translate.All')); ?></option>
                  <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($warehouse->id); ?>"><?php echo e($warehouse->name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>


            </div>

            <div class="row mt-3">

              <div class="col-md-6">
                <button type="submit" class="btn btn-primary">
                  <i class="i-Filter-2 me-2 font-weight-bold"></i> <?php echo e(__('translate.Filter')); ?>

                </button>
                <button id="Clear_Form" class="btn btn-danger">
                   <i class="i-Power-2 me-2 font-weight-bold"></i> <?php echo e(__('translate.Clear')); ?>

                </button>
              </div>
            </div>


          </form>

        </div>

      </div>
    </div>
  </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-js'); ?>

<script src="<?php echo e(asset('assets/js/vendor/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/nprogress.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datepicker.min.js')); ?>"></script>

<script type="text/javascript">
  $(function () {
      "use strict";

      $(document).ready(function () {

            $("#start_date,#end_date").datepicker({
                format: 'yyyy-mm-dd',
                changeMonth: true,
                changeYear: true,
                autoclose: true,
                todayHighlight: true,
            });

            var end_date = new Date();
            var start_date = new Date();

            end_date.setDate(end_date.getDate() + 365);
            $("#end_date").datepicker("setDate" , end_date);

            start_date.setDate(start_date.getDate() - 365);
            $("#start_date").datepicker("setDate" , start_date);

            //init datatable
            transfer_datatable();
      });


        //Get Data
        function transfer_datatable(start_date ='', end_date ='', Ref ='', from_warehouse_id ='',to_warehouse_id =''){
            var table = $('#transfer_table').DataTable({
                processing: true,
                serverSide: true,
                "order": [[ 0, "desc" ]],
                  'columnDefs': [
                      {
                          'targets': [0],
                          'visible': false,
                          'searchable': false,
                      },
                      {
                          'targets': [1,2,3,4,5,6,7],
                          "orderable": false,
                      },
                ],

                ajax: {
                    url: "/transfer/transfers",
                    data: {
                        start_date: start_date === null?'':start_date,
                        end_date: end_date === null?'':end_date,
                        Ref: Ref === null?'':Ref,
                        from_warehouse_id: from_warehouse_id == '0'?'':from_warehouse_id,
                        to_warehouse_id: to_warehouse_id == '0'?'':to_warehouse_id,
                        "_token": "<?php echo e(csrf_token()); ?>"
                    },
                },

                columns: [
                    {data: 'id', name: 'id', className: "d-none"},
                    {data: 'date', name: 'date'},
                    {data: 'Ref', name: 'Ref'},
                    {data: 'from_warehouse', name: 'from_warehouse'},
                    {data: 'to_warehouse', name: 'to_warehouse'},
                    {data: 'items', name: 'items'},
                    {data: 'GrandTotal', name: 'GrandTotal'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                
                ],
            
                lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
                dom: "<'row'<'col-sm-12 col-md-7'lB><'col-sm-12 col-md-5 p-0'f>>rtip",
                oLanguage: {
                        sEmptyTable: "<?php echo e(__('datatable.sEmptyTable')); ?>",
                        sInfo: "<?php echo e(__('datatable.sInfo')); ?>",
                        sInfoEmpty: "<?php echo e(__('datatable.sInfoEmpty')); ?>",
                        sInfoFiltered: "<?php echo e(__('datatable.sInfoFiltered')); ?>",
                        sInfoThousands: "<?php echo e(__('datatable.sInfoThousands')); ?>",
                        sLengthMenu: "_MENU_", 
                        sLoadingRecords: "<?php echo e(__('datatable.sLoadingRecords')); ?>",
                        sProcessing: "<?php echo e(__('datatable.sProcessing')); ?>",
                        sSearch: "",
                        sSearchPlaceholder: "<?php echo e(__('datatable.sSearchPlaceholder')); ?>",
                        oPaginate: {
                            sFirst: "<?php echo e(__('datatable.oPaginate.sFirst')); ?>",
                            sLast: "<?php echo e(__('datatable.oPaginate.sLast')); ?>",
                            sNext: "<?php echo e(__('datatable.oPaginate.sNext')); ?>",
                            sPrevious: "<?php echo e(__('datatable.oPaginate.sPrevious')); ?>",
                        },
                        oAria: {
                            sSortAscending: "<?php echo e(__('datatable.oAria.sSortAscending')); ?>",
                            sSortDescending: "<?php echo e(__('datatable.oAria.sSortDescending')); ?>",
                        }
                    },
                buttons: [
                    {
                        extend: 'collection',
                        text: "<?php echo e(__('translate.EXPORT')); ?>",
                        buttons: [
                          {
                            extend: 'print',
                            text: 'print',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                  return 'Transfers List';
                            },
                          },
                          {
                            extend: 'pdf',
                            text: 'pdf',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                  return 'Transfers List';
                            },
                          },
                          {
                            extend: 'excel',
                            text: 'excel',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                  return 'Transfers List';
                            },
                          },
                          {
                            extend: 'csv',
                            text: 'csv',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                  return 'Transfers List';
                            },
                          },
                        ]
                    }]
            });
        }

         // Clear Filter
         $('#Clear_Form').on('click' , function (e) {

            var end_date = new Date();
            var start_date = new Date();

            end_date.setDate(end_date.getDate() + 365);
            $("#end_date").datepicker("setDate" , end_date);

            start_date.setDate(start_date.getDate() - 365);
            $("#start_date").datepicker("setDate" , start_date);

            var Ref = $('#Ref').val('');
            let from_warehouse_id = $('#from_warehouse_id').val('0');
            let to_warehouse_id = $('#to_warehouse_id').val('0');

        });


         // Show Modal Filter
        $('#Show_Modal_Filter').on('click' , function (e) {
            $('#filter_transfer_modal').modal('show');
        });


         // Submit Filter
        $('#filter_transfer').on('submit' , function (e) {
            e.preventDefault();
            var start_date = $('#start_date').val();
            var end_date = $('#end_date').val();
            var Ref = $('#Ref').val();
            let from_warehouse_id = $('#from_warehouse_id').val();
            let to_warehouse_id = $('#to_warehouse_id').val();
      
            $('#transfer_table').DataTable().destroy();
            transfer_datatable(start_date, end_date, Ref, from_warehouse_id,to_warehouse_id);

            $('#filter_transfer_modal').modal('hide');
           
        });

        // event reload Datatatble
        $(document).bind('event_transfer', function (e) {
            $('#transfer_table').DataTable().destroy();
            transfer_datatable();
        });

        //Delete transfer
        $(document).on('click', '.delete', function () {
            var id = $(this).attr('id');
            app.Remove_transfer(id);
        });
    });
</script>

<script>
  var app = new Vue({
        el: '#section_transfer_list',
        data: {
            SubmitProcessing:false,
            transfers: [], 
        },
       
        methods: {


             //--------------------------------- Remove_transfer ---------------------------\\
             Remove_transfer(id) {

                swal({
                    title: '<?php echo e(__('translate.Are_you_sure')); ?>',
                    text: '<?php echo e(__('translate.You_wont_be_able_to_revert_this')); ?>',
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#0CC27E',
                    cancelButtonColor: '#FF586B',
                    confirmButtonText: '<?php echo e(__('translate.Yes_delete_it')); ?>',
                    cancelButtonText: '<?php echo e(__('translate.No_cancel')); ?>',
                    confirmButtonClass: 'btn btn-primary me-5',
                    cancelButtonClass: 'btn btn-danger',
                    buttonsStyling: false
                }).then(function () {
                        axios
                            .delete("/transfer/transfers/" + id)
                            .then(() => {
                                $.event.trigger('event_transfer');
                                toastr.success('<?php echo e(__('translate.Deleted_in_successfully')); ?>');

                            })
                            .catch(() => {
                                toastr.error('<?php echo e(__('translate.There_was_something_wronge')); ?>');
                            });
                    });
                },

         

        },
        //-----------------------------Autoload function-------------------
        created() {
        }

    })

</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/itlabsys/public_html/niwethma.itlabsystems.lk/resources/views/transfers/list_transfers.blade.php ENDPATH**/ ?>