
<?php $__env->startSection('main-content'); ?>

<?php $__env->startSection('page-css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/nprogress.css')); ?>">
<?php $__env->stopSection(); ?>

<div class="breadcrumb">
  <h1><?php echo e(__('translate.Products')); ?></h1>
</div>

<div class="separator-breadcrumb border-top"></div>

<div class="row" id="section_product_list">
  <div class="col-md-12">
    <div class="card">
      <div class="card-body">
        <div class="text-end mb-3">
          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products_add')): ?>
          <a href="/products/products/create" class=" btn btn-outline-primary btn-md m-1"><i class="i-Add me-2 font-weight-bold"></i>
            <?php echo e(__('translate.Create')); ?></a>
          <?php endif; ?>
          <a class="btn btn-outline-success btn-md m-1" id="Show_Modal_Filter"><i class="i-Filter-2 me-2 font-weight-bold"></i>
            <?php echo e(__('translate.Filter')); ?></a>
        </div>

        <div class="table-responsive">
          <table id="product_table" class="display table table-hover">
            <thead>
              <tr>
                <th>ID</th>
                <th><?php echo e(__('translate.Image')); ?></th>
                <th><?php echo e(__('translate.type')); ?></th>
                <th><?php echo e(__('translate.Name')); ?></th>
                <th><?php echo e(__('translate.Code')); ?></th>
                <th><?php echo e(__('translate.Category')); ?></th>
                <th><?php echo e(__('translate.Brand')); ?></th>
                <th><?php echo e(__('translate.Product_Cost')); ?></th>
                <th><?php echo e(__('translate.Product_Price')); ?></th>
                <th><?php echo e(__('translate.Current_Stock')); ?></th>
                <th class="not_show"><?php echo e(__('translate.Action')); ?></th>
              </tr>
            </thead>
            <tbody>
            </tbody>

          </table>
        </div>

      </div>
    </div>
  </div>
  <!-- Modal Filter -->
  <div class="modal fade" id="filter_products_modal" tabindex="-1" role="dialog" aria-labelledby="filter_products_modal"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title"><?php echo e(__('translate.Filter')); ?></h5>
         <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
  
          <form method="POST" id="filter_products">
            <?php echo csrf_field(); ?>
            <div class="row">
  
              <div class="form-group col-md-6">
                <label for="code"><?php echo e(__('translate.Code_Product')); ?>

                </label>
                <input type="text" class="form-control" name="code" id="code"
                  placeholder="<?php echo e(__('translate.Code_Product')); ?>">
              </div>
  
              <div class="form-group col-md-6">
                <label for="name"><?php echo e(__('translate.Product_Name')); ?>

                </label>
                <input type="text" class="form-control" name="name" id="product_name"
                  placeholder="<?php echo e(__('translate.Product_Name')); ?>">
              </div>
  
              <div class="form-group col-md-6">
                <label for="category_id"><?php echo e(__('translate.Category')); ?>

                </label>
                <select name="category_id" id="category_id" class="form-control">
                  <option value="0"><?php echo e(__('translate.All')); ?></option>
                  <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
  
              <div class="form-group col-md-6">
                <label for="brand_id"><?php echo e(__('translate.Brand')); ?>

                </label>
                <select name="brand_id" id="brand_id" class="form-control">
                  <option value="0"><?php echo e(__('translate.All')); ?></option>
                  <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($brand->id); ?>"><?php echo e($brand->name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
  
            </div>
  
            <div class="row mt-3">
  
              <div class="col-md-6">
                <button type="submit" class="btn btn-primary">
                  <i class="i-Filter-2 me-2 font-weight-bold"></i> <?php echo e(__('translate.Filter')); ?>

                </button>
                <button id="Clear_Form" class="btn btn-danger">
                   <i class="i-Power-2 me-2 font-weight-bold"></i> <?php echo e(__('translate.Clear')); ?>

                </button>
              </div>
            </div>
  
  
          </form>
  
        </div>
  
      </div>
    </div>
  </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-js'); ?>

<script src="<?php echo e(asset('assets/js/vendor/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/nprogress.js')); ?>"></script>

<script type="text/javascript">
  $(function () {
      "use strict";
      $(document).ready(function () {
        //init datatable
        product_datatable();
      });

        //Get Data
        function product_datatable(name ='', category_id ='',brand_id ='', code =''){
            var table = $('#product_table').DataTable({
                processing: true,
                serverSide: true,
                "order": [[ 0, "desc" ]],
                'columnDefs': [
                  {
                      'targets': [0],
                      'visible': false,
                      'searchable': false,
                  },
                  {
                      'targets': [1,2,5,6,7,8,9,10],
                      "orderable": false,
                  },
                ],

                ajax: {
                    url: "<?php echo e(route('products_datatable')); ?>",
                    data: {
                        name: name === null?'':name,
                        category_id: category_id == '0'?'':category_id,
                        brand_id: brand_id == '0'?'':brand_id,
                        code: code === null?'':code,
                        "_token": "<?php echo e(csrf_token()); ?>"
                    },
                    dataType: "json",
                    type:"post"
                },

                columns: [
                    {data: 'id' , className: "d-none"},
                    {data: 'image'},
                    {data: 'type'},
                    {data: 'name'},
                    {data: 'code'},
                    {data: 'category'},
                    {data: 'brand'},
                    {data: 'cost'},
                    {data: 'price'},
                    {data: 'quantity'},
                    {data: 'action'},
                
                ],
            
                lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
                dom: "<'row'<'col-sm-12 col-md-7'lB><'col-sm-12 col-md-5 p-0'f>>rtip",
                oLanguage: {
                    sEmptyTable: "<?php echo e(__('datatable.sEmptyTable')); ?>",
                    sInfo: "<?php echo e(__('datatable.sInfo')); ?>",
                    sInfoEmpty: "<?php echo e(__('datatable.sInfoEmpty')); ?>",
                    sInfoFiltered: "<?php echo e(__('datatable.sInfoFiltered')); ?>",
                    sInfoThousands: "<?php echo e(__('datatable.sInfoThousands')); ?>",
                    sLengthMenu: "_MENU_", 
                    sLoadingRecords: "<?php echo e(__('datatable.sLoadingRecords')); ?>",
                    sProcessing: "<?php echo e(__('datatable.sProcessing')); ?>",
                    sSearch: "",
                    sSearchPlaceholder: "<?php echo e(__('datatable.sSearchPlaceholder')); ?>",
                    oPaginate: {
                        sFirst: "<?php echo e(__('datatable.oPaginate.sFirst')); ?>",
                        sLast: "<?php echo e(__('datatable.oPaginate.sLast')); ?>",
                        sNext: "<?php echo e(__('datatable.oPaginate.sNext')); ?>",
                        sPrevious: "<?php echo e(__('datatable.oPaginate.sPrevious')); ?>",
                    },
                    oAria: {
                        sSortAscending: "<?php echo e(__('datatable.oAria.sSortAscending')); ?>",
                        sSortDescending: "<?php echo e(__('datatable.oAria.sSortDescending')); ?>",
                    }
                },
                buttons: [
                    {
                        extend: 'collection',
                        text: "<?php echo e(__('translate.EXPORT')); ?>",
                        buttons: [
                          {
                            extend: 'print',
                            text: 'print',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                return 'Products List';
                            },
                          },
                          {
                            extend: 'pdf',
                            text: 'pdf',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                return 'Products List';
                            },
                          },
                          {
                            extend: 'excel',
                            text: 'excel',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                return 'Products List';
                            },
                          },
                          {
                            extend: 'csv',
                            text: 'csv',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                return 'Products List';
                            },
                          },
                        ]
                    }]
                   
            });
        }

        // Clear Filter
        $('#Clear_Form').on('click' , function (e) {
            var name = $('#product_name').val('');
            let category_id = $('#category_id').val('0');
            let brand_id = $('#brand_id').val('0');
            var code = $('#code').val('');

        });


         // Show Modal Filter
        $('#Show_Modal_Filter').on('click' , function (e) {
            $('#filter_products_modal').modal('show');
        });


         // Submit Filter
        $('#filter_products').on('submit' , function (e) {
            e.preventDefault();
            var name = $('#product_name').val();
            let category_id = $('#category_id').val();
            let brand_id = $('#brand_id').val();
            var code = $('#code').val();
      
            $('#product_table').DataTable().destroy();
            product_datatable(name, category_id, brand_id, code);

            $('#filter_products_modal').modal('hide');
           
        });

        // event reload Datatatble
        $(document).bind('event_product', function (e) {
            $('#product_table').DataTable().destroy();
            product_datatable();
        });

         //Delete Category
         $(document).on('click', '.delete', function () {
            var id = $(this).attr('id');
            app.Remove_product(id);
        });

    });
</script>

<script>
  var app = new Vue({
        el: '#section_product_list',
        data: {
            editmode: false,
            SubmitProcessing:false,
            errors:[],
            products: [], 
        },
       
        methods: {


             //--------------------------------- Remove_product ---------------------------\\
             Remove_product(id) {

                swal({
                    title: '<?php echo e(__('translate.Are_you_sure')); ?>',
                    text: '<?php echo e(__('translate.You_wont_be_able_to_revert_this')); ?>',
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#0CC27E',
                    cancelButtonColor: '#FF586B',
                    confirmButtonText: '<?php echo e(__('translate.Yes_delete_it')); ?>',
                    cancelButtonText: '<?php echo e(__('translate.No_cancel')); ?>',
                    confirmButtonClass: 'btn btn-primary me-5',
                    cancelButtonClass: 'btn btn-danger',
                    buttonsStyling: false
                }).then(function () {
                        axios
                            .delete("/products/products/" + id)
                            .then(() => {
                                $.event.trigger('event_product');
                                toastr.success('<?php echo e(__('translate.Deleted_in_successfully')); ?>');

                            })
                            .catch(() => {
                                toastr.error('<?php echo e(__('translate.There_was_something_wronge')); ?>');
                            });
                    });
                },

         

        },
        //-----------------------------Autoload function-------------------
        created() {
        }

    })

</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/itlabsys/public_html/niwethma.itlabsystems.lk/resources/views/products/list_product.blade.php ENDPATH**/ ?>