<?php
    $path = Request::path();
    $parentPath = explode("/",$path)[0];
    $setting = DB::table('settings')->where('deleted_at', '=', null)->first();
?>

<!-- start sidebar -->
<div 
    x-data="{ isCompact: false }" 
    :class="isCompact ? 'compact' : ''" 
    class="sidebar-content bg-gray-900 card rounded-0"
>
    <div class="sidebar-header mb-5 d-flex justify-content-between align-items-center">
        <div class="d-flex align-items-center">
            <img class="app-logo me-2" width="100" src="<?php echo e(asset('images/'.$setting->logo)); ?>" alt="">
        </div>
        <button 
            @click="isCompact = !isCompact"
            class="compact-button btn border border-gray-600 d-none d-lg-flex align-items-center p-1 width_24" 
        >
            <?php echo $__env->make('components.icons.collapse', ['class'=>'width_16'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </button>
        <button 
            class="close-sidebar btn border border-gray-600 d-flex d-lg-none align-items-center p-1 width_24" 
        >
            <?php echo $__env->make('components.icons.collapse', ['class'=>'width_16'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </button>
    </div>

    <!-- user -->
    <div class="scroll-nav" data-perfect-scrollbar data-suppress-scroll-x="true">
        <ul x-data="collapse('<?php echo e($parentPath); ?>')" class="list-group" id="menu">
            
            <li class="">
                <a href="/" class="nav-item <?php if($path == 'dashboard/admin'): ?> active <?php endif; ?>">
                    <?php echo $__env->make('components.icons.dashboard', ['class'=>'width_16'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <span class="item-name"><?php echo e(__('translate.dashboard')); ?></span>
                </a>
            </li>            

            
            <?php if(auth()->user()->can('user_view') || auth()->user()->can('group_permission')): ?>
                <li>
                    <div 
                        @click="selectCollapse('user-management')"
                        :class="selected == 'user-management' ? 'collapse-active' : 'collapse-deactive'"
                        class="collapse-button"
                    >
                        <?php echo $__env->make('components.sidebar.collapse-navitem', [
                            'title'=>__('translate.UserManagement'), 
                            'icon'=>'components.icons.user'
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div
                        x-ref="user-management"
                        x-bind:style="activeCollapse($refs, 'user-management', selected)"
                        class="collapse-content"
                    >
                        <ul class="list-group">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_view')): ?>
                                <li class="">
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/user-management/users', 
                                        'title'=> __('translate.Users')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('group_permission')): ?>
                                <li class="">
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/user-management/permissions', 
                                        'title'=> __('translate.Roles')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>

            
            <?php if(auth()->user()->can('client_view_all') || auth()->user()->can('client_view_own') || auth()->user()->can('suppliers_view_all') || auth()->user()->can('suppliers_view_own')): ?>
                <li>
                    <div 
                        @click="selectCollapse('people')"
                        :class="selected == 'people' ? 'collapse-active' : 'collapse-deactive'"
                        class="collapse-button"
                    >
                        <?php echo $__env->make('components.sidebar.collapse-navitem', [
                            'title'=>__('translate.People'), 
                            'icon'=>'components.icons.customers'
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div
                        x-ref="people"
                        x-bind:style="activeCollapse($refs, 'people', selected)"
                        class="collapse-content"
                    >
                        <ul class="list-group">
                            <?php if(auth()->user()->can('client_view_all') || auth()->user()->can('client_view_own')): ?>
                                <li class="">
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/people/clients', 
                                        'title'=> __('translate.Customers')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if(auth()->user()->can('suppliers_view_all') || auth()->user()->can('suppliers_view_own')): ?>
                                <li class="">
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/people/suppliers', 
                                        'title'=> __('translate.Suppliers')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>

            
            <?php if(auth()->user()->can('products_add') || auth()->user()->can('products_view')|| auth()->user()->can('category')
            || auth()->user()->can('brand') || auth()->user()->can('unit') || auth()->user()->can('warehouse') || auth()->user()->can('print_labels')): ?>
                <li>
                    <div 
                        @click="selectCollapse('products')"
                        :class="selected == 'products' ? 'collapse-active' : 'collapse-deactive'"
                        class="collapse-button"
                    >
                        <?php echo $__env->make('components.sidebar.collapse-navitem', [
                            'title'=>__('translate.Products'), 
                            'icon'=>'components.icons.product'
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div
                        x-ref="products"
                        x-bind:style="activeCollapse($refs, 'products', selected)"
                        class="collapse-content"
                    >
                        <ul class="list-group">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products_view')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/products/products', 
                                        'title'=> __('translate.productsList')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products_add')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/products/products/create', 
                                        'title'=> __('translate.AddProduct')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('print_labels')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/products/print_labels', 
                                        'title'=> __('translate.Print_Labels')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/products/categories', 
                                        'title'=> __('translate.Categories')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('unit')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/products/units', 
                                        'title'=> __('translate.Units')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('brand')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/products/brands', 
                                        'title'=> __('translate.Brand')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/products/warehouses', 
                                        'title'=> __('translate.Warehouses')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>

            
            <?php if(auth()->user()->can('adjustment_view_all') || auth()->user()->can('adjustment_view_own') || auth()->user()->can('adjustment_add')): ?>
                <li>
                    <div 
                        @click="selectCollapse('adjustment')"
                        :class="selected == 'adjustment' ? 'collapse-active' : 'collapse-deactive'"
                        class="collapse-button"
                    >
                        <?php echo $__env->make('components.sidebar.collapse-navitem', [
                            'title'=>__('translate.StockAdjustement'), 
                            'icon'=>'components.icons.store'
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div
                        x-ref="adjustment"
                        x-bind:style="activeCollapse($refs, 'adjustment', selected)"
                        class="collapse-content"
                    >
                        <ul class="list-group">
                            <?php if(auth()->user()->can('adjustment_view_all') || auth()->user()->can('adjustment_view_own')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/adjustment/adjustments', 
                                        'title'=> __('translate.ListAdjustments')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('adjustment_add')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/adjustment/adjustments/create', 
                                        'title'=> __('translate.CreateAdjustment')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>  
            <?php endif; ?>

            
            <?php if(auth()->user()->can('transfer_view_all') || auth()->user()->can('transfer_view_own') || auth()->user()->can('transfer_add')): ?>
                <li>
                    <div 
                        @click="selectCollapse('transfer')"
                        :class="selected == 'transfer' ? 'collapse-active' : 'collapse-deactive'"
                        class="collapse-button"
                    >
                        <?php echo $__env->make('components.sidebar.collapse-navitem', [
                            'title'=>__('translate.StockTransfers'), 
                            'icon'=>'components.icons.refund'
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div
                        x-ref="transfer"
                        x-bind:style="activeCollapse($refs, 'transfer', selected)"
                        class="collapse-content"
                    >
                        <ul class="list-group">
                            <?php if(auth()->user()->can('transfer_view_all') || auth()->user()->can('transfer_view_own')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/transfer/transfers', 
                                        'title'=> __('translate.ListTransfers')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transfer_add')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/transfer/transfers/create', 
                                        'title'=> __('translate.CreateTransfer')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>

            
            <?php if(auth()->user()->can('quotations_view_all')  || auth()->user()->can('quotations_view_own') || auth()->user()->can('quotations_add')): ?>
                <li>
                    <div 
                        @click="selectCollapse('quotation')"
                        :class="selected == 'quotation' ? 'collapse-active' : 'collapse-deactive'"
                        class="collapse-button"
                    >
                        <?php echo $__env->make('components.sidebar.collapse-navitem', [
                            'title'=>__('translate.Quotations'), 
                            'icon'=>'components.icons.order'
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div
                        x-ref="quotation"
                        x-bind:style="activeCollapse($refs, 'quotation', selected)"
                        class="collapse-content"
                    >
                        <ul class="list-group">
                            <?php if(auth()->user()->can('quotations_view_all')  || auth()->user()->can('quotations_view_own')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/quotation/quotations', 
                                        'title'=> __('translate.All_Quotations')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quotations_add')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/quotation/quotations/create', 
                                        'title'=> __('translate.Add_Quotation')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li> 
            <?php endif; ?>

             
            <?php if(auth()->user()->can('purchases_view_all') || auth()->user()->can('purchases_view_own') || auth()->user()->can('purchases_add')): ?>
                <li>
                    <div 
                        @click="selectCollapse('purchase')"
                        :class="selected == 'purchase' ? 'collapse-active' : 'collapse-deactive'"
                        class="collapse-button"
                    >
                        <?php echo $__env->make('components.sidebar.collapse-navitem', [
                            'title'=>__('translate.Purchases'), 
                            'icon'=>'components.icons.cart'
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div
                        x-ref="purchase"
                        x-bind:style="activeCollapse($refs, 'purchase', selected)"
                        class="collapse-content"
                    >
                        <ul class="list-group">
                            <?php if(auth()->user()->can('purchases_view_all') || auth()->user()->can('purchases_view_own')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/purchase/purchases', 
                                        'title'=> __('translate.ListPurchases')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchases_add')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/purchase/purchases/create', 
                                        'title'=> __('translate.AddPurchase')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li> 
            <?php endif; ?>

            
            <?php if(auth()->user()->can('sales_view_all') || auth()->user()->can('sales_view_own') || auth()->user()->can('sales_add')): ?>
                <li>
                    <div 
                        @click="selectCollapse('sale')"
                        :class="selected == 'sale' ? 'collapse-active' : 'collapse-deactive'"
                        class="collapse-button"
                    >
                        <?php echo $__env->make('components.sidebar.collapse-navitem', [
                            'title'=>__('translate.Sales'), 
                            'icon'=>'components.icons.add-to-cart'
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div
                        x-ref="sale"
                        x-bind:style="activeCollapse($refs, 'sale', selected)"
                        class="collapse-content"
                    >
                        <ul class="list-group">
                            <?php if(auth()->user()->can('sales_view_all') || auth()->user()->can('sales_view_own')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/sale/sales', 
                                        'title'=> __('translate.ListSales')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sales_add')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/sale/sales/create', 
                                        'title'=> __('translate.AddSale')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li> 
            <?php endif; ?>

            
            <?php if(auth()->user()->can('sale_returns_view_all') || auth()->user()->can('sale_returns_view_own')): ?>

            <li class="">
                <a href="/sales-return/returns_sale" class="nav-item <?php if($path == 'sales-return/returns_sale'): ?> active <?php endif; ?>">
                    <?php echo $__env->make('components.icons.sales-return', ['class'=>'width_16'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <span class="item-name"><?php echo e(__('translate.SalesReturn')); ?></span>
                </a>
            </li>  

            <?php endif; ?>

            
            <?php if(auth()->user()->can('purchase_returns_view_all') || auth()->user()->can('purchase_returns_view_own')): ?>

            <li class="">
                <a href="/purchase-return/returns_purchase" class="nav-item <?php if($path == 'purchase-return/returns_purchase'): ?> active <?php endif; ?>">
                    <?php echo $__env->make('components.icons.purchases-return', ['class'=>'width_16'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <span class="item-name"><?php echo e(__('translate.PurchasesReturn')); ?></span>
                </a>
            </li>  
            <?php endif; ?>
       
            
            <?php if(auth()->user()->can('account_view') ||
            auth()->user()->can('deposit_view') ||
            auth()->user()->can('expense_view') ||
            auth()->user()->can('expense_category') ||
            auth()->user()->can('deposit_category') ||
            auth()->user()->can('payment_method')): ?>
                <li>
                    <div 
                        @click="selectCollapse('accounting')"
                        :class="selected == 'accounting' ? 'collapse-active' : 'collapse-deactive'"
                        class="collapse-button"
                    >
                        <?php echo $__env->make('components.sidebar.collapse-navitem', [
                            'title'=>__('translate.Accounting'), 
                            'icon'=>'components.icons.account'
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div
                        x-ref="accounting"
                        x-bind:style="activeCollapse($refs, 'accounting', selected)"
                        class="collapse-content"
                    >
                        <ul class="list-group">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('account_view')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/accounting/account', 
                                        'title'=> __('translate.Account')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('deposit_view')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/accounting/deposit', 
                                        'title'=> __('translate.Deposit')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('expense_view')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/accounting/expense', 
                                        'title'=> __('translate.Expense')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('expense_category')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/accounting/expense_category', 
                                        'title'=> __('translate.Expense_Category')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('deposit_category')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/accounting/deposit_category', 
                                        'title'=> __('translate.Deposit_Category')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment_method')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/accounting/payment_methods', 
                                        'title'=> __('translate.Payment_Methods')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li> 
            <?php endif; ?>

            
            <?php if(auth()->user()->can('settings') || auth()->user()->can('backup') || auth()->user()->can('currency')
            || auth()->user()->can('sms_settings') || auth()->user()->can('notification_template') || auth()->user()->can('pos_settings')): ?>
                <li>
                    <div 
                        @click="selectCollapse('settings')"
                        :class="selected == 'settings' ? 'collapse-active' : 'collapse-deactive'"
                        class="collapse-button"
                    >
                        <?php echo $__env->make('components.sidebar.collapse-navitem', [
                            'title'=>__('translate.Settings'), 
                            'icon'=>'components.icons.settings'
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div
                        x-ref="settings"
                        x-bind:style="activeCollapse($refs, 'settings', selected)"
                        class="collapse-content"
                    >
                        <ul class="list-group">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/settings/system_settings', 
                                        'title'=> __('translate.System_Settings')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pos_settings')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/settings/pos_settings', 
                                        'title'=> __('translate.Pos_Receipt_Settings')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sms_settings')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/settings/sms_settings', 
                                        'title'=> __('translate.sms_settings')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('notification_template')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/settings/sms_template', 
                                        'title'=> __('translate.sms_template')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>

                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/settings/emails_template', 
                                        'title'=> __('translate.emails_template')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('currency')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/settings/currency', 
                                        'title'=> __('translate.Currency')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('backup')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/settings/backup', 
                                        'title'=> __('translate.Backup')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>

            
            <?php if(auth()->user()->can('report_products') || 
            auth()->user()->can('report_inventaire') || auth()->user()->can('report_clients') || 
            auth()->user()->can('report_fournisseurs') || auth()->user()->can('reports_alert_qty') || 
            auth()->user()->can('report_profit') || auth()->user()->can('sale_reports') || 
            auth()->user()->can('purchase_reports') || auth()->user()->can('payment_sale_reports') || 
            auth()->user()->can('payment_purchase_reports') || auth()->user()->can('payment_return_purchase_reports') || 
            auth()->user()->can('payment_return_sale_reports') ): ?>
                <li>
                    <div 
                        @click="selectCollapse('reports')"
                        :class="selected == 'reports' ? 'collapse-active' : 'collapse-deactive'"
                        class="collapse-button"
                    >
                        <?php echo $__env->make('components.sidebar.collapse-navitem', [
                            'title'=>__('translate.Reports'), 
                            'icon'=>'components.icons.reports'
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div
                        x-ref="reports"
                        x-bind:style="activeCollapse($refs, 'reports', selected)"
                        class="collapse-content"
                    >
                        <ul class="list-group">

                           <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('report_profit')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/reports/report_profit', 
                                        'title'=> __('translate.ProfitandLoss')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sale_reports')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/reports/sale_report', 
                                        'title'=> __('translate.SalesReport')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                              
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase_reports')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/reports/purchase_report', 
                                        'title'=> __('translate.PurchasesReport')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                               
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('report_inventaire')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/reports/report_stock', 
                                        'title'=> __('translate.Inventory_report')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('report_products')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/reports/report_product', 
                                        'title'=> __('translate.product_report')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                           
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('report_clients')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/reports/report_clients', 
                                        'title'=> __('translate.CustomersReport')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('report_fournisseurs')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/reports/report_providers', 
                                        'title'=> __('translate.SuppliersReport')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment_sale_reports')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/reports/payment_sale', 
                                        'title'=> __('translate.payment_sale')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment_purchase_reports')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/reports/payment_purchase', 
                                        'title'=> __('translate.payment_purchase')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment_return_sale_reports')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/reports/payment_sale_return', 
                                        'title'=> __('translate.payment_sale_return')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment_return_purchase_reports')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/reports/payment_purchase_return', 
                                        'title'=> __('translate.payment_purchase_return')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports_alert_qty')): ?>
                                <li>
                                    <?php echo $__env->make('components.sidebar.child-navitem', [
                                        'href'=>'/reports/reports_quantity_alerts', 
                                        'title'=> __('translate.ProductQuantityAlerts')
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>
        </ul>
    </div>
</div><?php /**PATH /home/itlabsys/public_html/niwethma.itlabsystems.lk/resources/views/layouts/new-sidebar/sidebar.blade.php ENDPATH**/ ?>