
<?php $__env->startSection('main-content'); ?>
<?php $__env->startSection('page-css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/nprogress.css')); ?>">
<?php $__env->stopSection(); ?>

<div class="breadcrumb">
    <h1><?php echo e(__('translate.stock_report')); ?></h1>
</div>

<div class="separator-breadcrumb border-top"></div>


<div id="stock_report">
    <div class="row">
        <div class="form-group col-md-6">
            <label for="warehouse_id"><?php echo e(__('translate.warehouse')); ?>

            </label>
            <select name="warehouse_id" id="warehouse_id" class="form-control">
                <option value="0"><?php echo e(__('translate.All')); ?></option>
                <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($warehouse->id); ?>"><?php echo e($warehouse->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table id="stock_table" class="display table table-hover">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('translate.Code')); ?></th>
                                    <th><?php echo e(__('translate.Name')); ?></th>
                                    <th><?php echo e(__('translate.warehouse')); ?></th>
                                    <th><?php echo e(__('translate.Current_Stock')); ?></th>
                                    <th><?php echo e(__('translate.Total_Amount_Stock')); ?></th>
                                </tr>
                            </thead>
                            <tbody class="height_140">
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th><?php echo e(__('translate.Total')); ?> :</th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-js'); ?>

<script src="<?php echo e(asset('assets/js/vendor/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/nprogress.js')); ?>"></script>


<script type="text/javascript">
    $(function() {
        "use strict";

        $(document).ready(function () {
          //init datatable
          stock_datatable();
        });

     

            //Get Data
            function stock_datatable(warehouse_id =''){
                var $symbol_placement = <?php echo json_encode($symbol_placement, 15, 512) ?>;
                var table = $('#stock_table').DataTable({
                    processing: true,
                    serverSide: true,
                    'columnDefs': [
                    {
                        "orderable": false,
                        'targets': [0,1,2,3,4]
                    },
                    ],

                    ajax: {
                        url: "<?php echo e(route('get_report_stock_datatable')); ?>",
                        data: {
                            warehouse_id: warehouse_id == '0'?'':warehouse_id,
                            
                            "_token": "<?php echo e(csrf_token()); ?>"
                        },
                        dataType: "json",
                        type:"post"
                    },
                    columns: [
                        {data: 'code'},
                        {data: 'name'},
                        {data: 'warehouse_name'},
                        {data: 'current_stock'},
                        {data: 'total_current_stock'},
                    ],

                    footerCallback: function (row, data, start, end, display) {
                        var api = this.api();
            
                        // Remove the formatting to get integer data for summation
                        var intVal = function (i) {
                            return typeof i === 'string' ? i.replace(/[\$, ]/g, '') * 1 : typeof i === 'number' ? i : 0;
                        };

                     
                        var total_current_stock = api.column(4, { page: 'current' }).data().reduce(function (a, b) {
                            return intVal(a) + intVal(b);
                        }, 0);

                    
                        // Update footer
                        var numberRenderer = $.fn.dataTable.render.number(',', '.', 2).display;

                        if ($symbol_placement == 'before') {
                            $(api.column(4).footer()).html('<?php echo e($currency); ?>' +' '+ numberRenderer(total_current_stock));
                        }else{
                            $(api.column(4).footer()).html(numberRenderer(total_current_stock) +' ' +'<?php echo e($currency); ?>');
                        }
                    },
                
                    lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
                    dom: "<'row'<'col-sm-12 col-md-7'lB><'col-sm-12 col-md-5 p-0'f>>rtip",
                    oLanguage: {
                        sEmptyTable: "<?php echo e(__('datatable.sEmptyTable')); ?>",
                        sInfo: "<?php echo e(__('datatable.sInfo')); ?>",
                        sInfoEmpty: "<?php echo e(__('datatable.sInfoEmpty')); ?>",
                        sInfoFiltered: "<?php echo e(__('datatable.sInfoFiltered')); ?>",
                        sInfoThousands: "<?php echo e(__('datatable.sInfoThousands')); ?>",
                        sLengthMenu: "_MENU_", 
                        sLoadingRecords: "<?php echo e(__('datatable.sLoadingRecords')); ?>",
                        sProcessing: "<?php echo e(__('datatable.sProcessing')); ?>",
                        sSearch: "",
                        sSearchPlaceholder: "<?php echo e(__('datatable.sSearchPlaceholder')); ?>",
                        oPaginate: {
                            sFirst: "<?php echo e(__('datatable.oPaginate.sFirst')); ?>",
                            sLast: "<?php echo e(__('datatable.oPaginate.sLast')); ?>",
                            sNext: "<?php echo e(__('datatable.oPaginate.sNext')); ?>",
                            sPrevious: "<?php echo e(__('datatable.oPaginate.sPrevious')); ?>",
                        },
                        oAria: {
                            sSortAscending: "<?php echo e(__('datatable.oAria.sSortAscending')); ?>",
                            sSortDescending: "<?php echo e(__('datatable.oAria.sSortDescending')); ?>",
                        }
                    },
                    buttons: [
                    {
                        extend: 'collection',
                        text: "<?php echo e(__('translate.EXPORT')); ?>",
                        buttons: [
                          {
                            extend: 'print',
                            text: 'Print',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                                return 'Report Stock';
                            },
                          },
                          {
                            extend: 'pdf',
                            text: 'Pdf',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                              return 'Report Stock';
                            },
                           
                        },
                          {
                            extend: 'excel',
                            text: 'Excel',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                              return 'Report Stock';
                            },
                          },
                          {
                            extend: 'csv',
                            text: 'Csv',
                            exportOptions: {
                                columns: ':visible:Not(.not_show)',
                                rows: ':visible'
                            },
                            title: function(){
                              return 'Report Stock';
                            },
                          },
                        ]
                }],
                });
            }


           // Submit Filter
           $('#warehouse_id').on('change' , function (e) {
               
               let warehouse_id = $('#warehouse_id').val();
       
               $('#stock_table').DataTable().destroy();
               stock_datatable(warehouse_id);

           });

      
    });
</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/itlabsys/public_html/niwethma.itlabsystems.lk/resources/views/reports/report_stock.blade.php ENDPATH**/ ?>