
<?php $__env->startSection('main-content'); ?>
<?php $__env->startSection('page-css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/datatables.min.css')); ?>">
<?php $__env->stopSection(); ?>

<div class="breadcrumb">
    <h1><?php echo e(__('translate.Backup')); ?></h1>
</div>

<div class="separator-breadcrumb border-top"></div>


<div class="row" id="section_backup_list">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="text-end mb-3">


                    <a :disabled="SubmitProcessing" id="generate_backup" @click="generate_backup"
                        class="btn btn-outline-primary btn-md m-1">
                        <span v-if="SubmitProcessing" class="spinner-border spinner-border-sm" role="status"
                            aria-hidden="true"></span> <i class="i-Yes me-2 font-weight-bold"></i>
                        <?php echo e(__('translate.Generate_backup')); ?></a>
                </div>
                <div class="alert alert-danger"> <?php echo e(__('translate.You_will_find_your_backups_on')); ?> <strong>/storage/app/public/backup</strong> <?php echo e(__('translate.and_save_it_to_your_pc')); ?></div>

                <div class="table-responsive">
                    <table id="ul-contact-list" class="display table">
                        <thead>
                            <tr>
                                <th><?php echo e(__('translate.Date')); ?></th>
                                <th><?php echo e(__('translate.File_size')); ?></th>
                                <th><?php echo e(__('translate.Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>


                    </table>

                </div>


            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-js'); ?>

<script src="<?php echo e(asset('assets/js/vendor/datatables.min.js')); ?>"></script>

<script type="text/javascript">
    $(function () {
        "use strict";

        $(document).ready(function () {
          //init datatable
          backup_datatable();
        });

        function backup_datatable(){
            var dataTable = $('#ul-contact-list').DataTable({
                buttons: [],
                pageLength: 10,
                "order": [[ 0, "desc" ]],
                ajax: {
                    url: "/settings/backup",
                },

                columns: [
                    {data: 'date', name: 'Date'},
                    {data: 'size', name: 'File Size'},
                    {data: 'action', name: 'action'},
                ],
                "processing": true, // for show progress bar
       
                dom: "<'row'<'col-sm-12 col-md-7'lB><'col-sm-12 col-md-5 p-0'f>>rtip",
                oLanguage: {
                    sEmptyTable: "<?php echo e(__('datatable.sEmptyTable')); ?>",
                    sInfo: "<?php echo e(__('datatable.sInfo')); ?>",
                    sInfoEmpty: "<?php echo e(__('datatable.sInfoEmpty')); ?>",
                    sInfoFiltered: "<?php echo e(__('datatable.sInfoFiltered')); ?>",
                    sInfoThousands: "<?php echo e(__('datatable.sInfoThousands')); ?>",
                    sLengthMenu: "_MENU_", 
                    sLoadingRecords: "<?php echo e(__('datatable.sLoadingRecords')); ?>",
                    sProcessing: "<?php echo e(__('datatable.sProcessing')); ?>",
                    sSearch: "",
                    sSearchPlaceholder: "<?php echo e(__('datatable.sSearchPlaceholder')); ?>",
                    oPaginate: {
                        sFirst: "<?php echo e(__('datatable.oPaginate.sFirst')); ?>",
                        sLast: "<?php echo e(__('datatable.oPaginate.sLast')); ?>",
                        sNext: "<?php echo e(__('datatable.oPaginate.sNext')); ?>",
                        sPrevious: "<?php echo e(__('datatable.oPaginate.sPrevious')); ?>",
                    },
                    oAria: {
                        sSortAscending: "<?php echo e(__('datatable.oAria.sSortAscending')); ?>",
                        sSortDescending: "<?php echo e(__('datatable.oAria.sSortDescending')); ?>",
                    }
                },              
            });
        }

        
          //Remove_Backup
          $(document).on('click', '.delete', function () {
              var id = $(this).attr('id');
              app.Remove_Backup(id);
          });
       
    });
</script>
<script>
    var app = new Vue({
        el: '#section_backup_list',
        data: {
            SubmitProcessing:false,
            errors:[],
           
        },
       
        methods: {

     
            //------------------------ generate_backup ---------------------------\\
            generate_backup() {
                var self = this;
                self.SubmitProcessing = true;
                axios.get("/GenerateBackup").then(response => {
                        self.SubmitProcessing = false;
                        window.location.href = '/settings/backup'; 
                        toastr.success('<?php echo e(__('translate.Created_in_successfully')); ?>');
                        self.errors = {};
                })
                .catch(error => {
                    self.SubmitProcessing = false;
                    if (error.response.status == 422) {
                        self.errors = error.response.data.errors;
                    }
                    toastr.error('<?php echo e(__('translate.There_was_something_wronge')); ?>');
                });
            },

            //--------------------------------- Remove Backup ---------------------------\\
            Remove_Backup(id) {

                swal({
                    title: '<?php echo e(__('translate.Are_you_sure')); ?>',
                    text: '<?php echo e(__('translate.You_wont_be_able_to_revert_this')); ?>',
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#0CC27E',
                    cancelButtonColor: '#FF586B',
                    confirmButtonText: '<?php echo e(__('translate.Yes_delete_it')); ?>',
                    cancelButtonText: '<?php echo e(__('translate.No_cancel')); ?>',
                    confirmButtonClass: 'btn btn-primary me-5',
                    cancelButtonClass: 'btn btn-danger',
                    buttonsStyling: false
                }).then(function () {
                        axios
                            .delete("/settings/backup/" + id)
                            .then(() => {
                                window.location.href = '/settings/backup'; 
                                toastr.success('<?php echo e(__('translate.Deleted_in_successfully')); ?>');

                            })
                            .catch(() => {
                                toastr.error('<?php echo e(__('translate.There_was_something_wronge')); ?>');
                            });
                    });
            },


   
           
        },
        //-----------------------------Autoload function-------------------
        created() {
        }

    })

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/itlabsys/public_html/niwethma.itlabsystems.lk/resources/views/settings/backup_list.blade.php ENDPATH**/ ?>